/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.util;

import com.taobao.text.Format;
import com.taobao.text.LineReader;
import com.taobao.text.LineRenderer;
import com.taobao.text.RenderAppendable;
import com.taobao.text.Renderer;
import com.taobao.text.ScreenBuffer;
import com.taobao.text.ScreenContext;
import com.taobao.text.Screenable;
import com.taobao.text.Style;
import com.taobao.text.ui.BorderStyle;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.RowElement;
import com.taobao.text.ui.TableElement;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RenderUtil {
    public static final int defaultWidth = 80;
    public static final int defaultHeight = 80;

    public static <O> String render(List<O> list) {
        LinkedList<Method> fieldMethods = new LinkedList<Method>();
        ArrayList<String> fields = new ArrayList<String>();
        O obj = list.get(0);
        for (Method method : obj.getClass().getMethods()) {
            String field;
            if (method.getDeclaringClass().equals(Object.class)) continue;
            String methodName = method.getName();
            int methodNameLength = methodName.length();
            if (methodNameLength > "get".length() && methodName.startsWith("get")) {
                fieldMethods.add(method);
                field = methodName.substring("get".length());
                fields.add(field);
            }
            if (methodNameLength <= "is".length() || !methodName.startsWith("is")) continue;
            fieldMethods.add(method);
            field = methodName.substring("is".length());
            fields.add(field);
        }
        if (fieldMethods.isEmpty()) {
            return "NULL";
        }
        Collections.sort(fields);
        Collections.sort(fieldMethods, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m22) {
                return m1.getName().compareTo(m22.getName());
            }
        });
        return RenderUtil.render(list, fields, fieldMethods);
    }

    public static <O> String render(List<O> list, String[] fields) {
        if (list == null || fields == null || fields.length == 0) {
            return "NULL";
        }
        if (list.size() == 0) {
            return "EMPTY LIST";
        }
        ArrayList<Method> fieldMethods = new ArrayList<Method>(fields.length);
        O object = list.get(0);
        String[] stringArray = fields;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String field;
            String uppercaseFieldName = field = stringArray[i];
            char first = field.charAt(0);
            if (first >= 'a' && first <= 'z') {
                first = (char)(first - 32);
                uppercaseFieldName = first + field.substring(1);
            }
            Method method = null;
            try {
                method = object.getClass().getMethod("get" + uppercaseFieldName, new Class[0]);
            }
            catch (Exception e) {
                try {
                    method = object.getClass().getMethod("is" + uppercaseFieldName, new Class[0]);
                }
                catch (Exception ee) {
                    throw new RuntimeException("can not find get/is method!", ee);
                }
            }
            fieldMethods.add(method);
        }
        return RenderUtil.render(list, Arrays.asList(fields), fieldMethods);
    }

    private static <O> String render(List<O> list, List<String> fields, List<Method> fieldMethods) {
        TableElement tableElement = new TableElement().border(BorderStyle.DASHED).separator(BorderStyle.DASHED);
        tableElement.row(true, fields.toArray(new String[0]));
        for (O object : list) {
            RowElement row = Element.row();
            for (Method method : fieldMethods) {
                String cell = null;
                try {
                    Object callResult = method.invoke(object, new Object[0]);
                    cell = callResult == null ? "null" : callResult.toString();
                }
                catch (Exception e) {
                    cell = "exception";
                }
                row.add(Element.label(cell));
            }
            tableElement.add(row);
        }
        return RenderUtil.render(tableElement);
    }

    public static String render(Element element) {
        return RenderUtil.render(element, 80);
    }

    public static <E> String render(Iterator<E> iter, Renderer<E> renderer) {
        return RenderUtil.render(iter, renderer, 80);
    }

    public static <E> String render(Iterator<E> iter, Renderer<E> renderer, int width) {
        LineRenderer lineRenderer = renderer.renderer(iter);
        LineReader reader = lineRenderer.reader(width);
        return RenderUtil.render(reader, width, 80);
    }

    public static <E> String render(Iterator<E> iter, Renderer<E> renderer, int width, int height) {
        LineRenderer lineRenderer = renderer.renderer(iter);
        LineReader reader = lineRenderer.reader(width, height);
        return RenderUtil.render(reader, width, height);
    }

    public static String render(Element element, int width) {
        LineReader renderer = element.renderer().reader(width);
        return RenderUtil.render(renderer, width, 80);
    }

    public static String render(Element element, int width, int height) {
        LineReader renderer = element.renderer().reader(width, height);
        return RenderUtil.render(renderer, width, height);
    }

    public static String render(LineReader renderer, final int width, final int height) {
        StringBuilder result = new StringBuilder(2048);
        while (renderer.hasLine()) {
            final ScreenBuffer buffer = new ScreenBuffer();
            renderer.renderLine(new RenderAppendable(new ScreenContext(){

                @Override
                public int getWidth() {
                    return width;
                }

                @Override
                public int getHeight() {
                    return height;
                }

                @Override
                public Screenable append(CharSequence s2) throws IOException {
                    buffer.append(s2);
                    return this;
                }

                @Override
                public Appendable append(char c) throws IOException {
                    buffer.append(c);
                    return this;
                }

                @Override
                public Appendable append(CharSequence csq, int start, int end) throws IOException {
                    buffer.append(csq, start, end);
                    return this;
                }

                @Override
                public Screenable append(Style style) throws IOException {
                    buffer.append(style);
                    return this;
                }

                @Override
                public Screenable cls() throws IOException {
                    buffer.cls();
                    return this;
                }

                @Override
                public void flush() throws IOException {
                    buffer.flush();
                }
            }));
            StringBuilder sb = new StringBuilder();
            try {
                buffer.format(Format.ANSI, sb);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            result.append(sb.toString()).append('\n');
        }
        return result.toString();
    }

    public static String ansiToPlainText(String str) {
        if (str != null) {
            str = str.replaceAll("\u001b\\[[;\\d]*m", "");
        }
        return str;
    }

    public static String cls() {
        return "\u001b[H\u001b[2J";
    }
}

