/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text;

import com.taobao.text.ScreenContext;
import com.taobao.text.Screenable;
import com.taobao.text.Style;
import com.taobao.text.util.Pair;
import com.taobao.text.util.Utils;
import java.io.IOException;
import java.util.ArrayList;

public class VirtualScreen
implements ScreenContext {
    private int width;
    private int height;
    private final ArrayList<Foo> buffer;
    private Style style;
    private int offset;
    private int index;
    private int row;
    private int cursorX;
    private int cursorY;
    private int cursorOffset;
    private int cursorIndex;
    private Style cursorStyle;
    private final ScreenContext out;
    private int status;
    private static final int REFRESH = 0;
    private static final int PAINTING = 1;
    private static final int PAINTED = 3;

    public VirtualScreen(ScreenContext out) {
        this.out = out;
        this.width = Utils.notNegative(out.getWidth());
        this.height = Utils.notNegative(out.getHeight());
        this.cursorX = 0;
        this.cursorY = 0;
        this.cursorOffset = 0;
        this.cursorIndex = 0;
        this.offset = 0;
        this.index = 0;
        this.row = 0;
        this.buffer = new ArrayList();
        this.style = Style.style();
        this.status = 0;
        this.cursorStyle = null;
    }

    @Override
    public int getWidth() {
        return this.out.getWidth();
    }

    @Override
    public int getHeight() {
        return this.out.getHeight();
    }

    @Override
    public Screenable append(CharSequence s2) throws IOException {
        this.buffer.add(new Foo(s2, this.style));
        return this;
    }

    @Override
    public Screenable append(char c) throws IOException {
        return this.append(Character.toString(c));
    }

    @Override
    public Screenable append(CharSequence csq, int start, int end) throws IOException {
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public Screenable append(Style style) throws IOException {
        this.style = style.merge(style);
        return this;
    }

    @Override
    public Screenable cls() throws IOException {
        this.buffer.clear();
        this.cursorX = 0;
        this.cursorY = 0;
        this.cursorOffset = 0;
        this.cursorIndex = 0;
        this.offset = 0;
        this.index = 0;
        this.row = 0;
        this.status = 0;
        return this;
    }

    public synchronized VirtualScreen paint() throws IOException {
        if (this.status == 0) {
            this.out.cls();
            this.out.append(Style.reset);
            this.cursorStyle = Style.reset;
            this.status = 1;
        }
        if (this.buffer.size() > 0) {
            int prev = this.cursorIndex;
            while (this.cursorX < this.width && this.cursorY < this.height) {
                if (this.cursorIndex >= this.buffer.get((int)this.cursorOffset).text.length()) {
                    if (prev < this.cursorIndex) {
                        if (!this.buffer.get((int)this.cursorOffset).style.equals(this.cursorStyle)) {
                            this.out.append(this.buffer.get((int)this.cursorOffset).style);
                            this.cursorStyle = this.cursorStyle.merge(this.buffer.get((int)this.cursorOffset).style);
                        }
                        this.out.append(this.buffer.get((int)this.cursorOffset).text, prev, this.cursorIndex);
                    }
                    if (this.cursorOffset + 1 >= this.buffer.size()) {
                        return this;
                    }
                    prev = 0;
                    this.cursorIndex = 0;
                    ++this.cursorOffset;
                    continue;
                }
                char c = this.buffer.get((int)this.cursorOffset).text.charAt(this.cursorIndex);
                if (c == '\n') {
                    this.cursorX = 0;
                    ++this.cursorY;
                    if (this.cursorY >= this.height) continue;
                    ++this.cursorIndex;
                    continue;
                }
                if (c >= ' ') {
                    ++this.cursorX;
                    ++this.cursorIndex;
                    if (this.cursorX != this.width) continue;
                    this.cursorX = 0;
                    ++this.cursorY;
                    continue;
                }
                ++this.cursorIndex;
            }
            if (prev < this.cursorIndex) {
                if (!this.buffer.get((int)this.cursorOffset).style.equals(this.cursorStyle)) {
                    this.out.append(this.buffer.get((int)this.cursorOffset).style);
                    this.cursorStyle = this.cursorStyle.merge(this.buffer.get((int)this.cursorOffset).style);
                }
                this.out.append(this.buffer.get((int)this.cursorOffset).text.subSequence(prev, this.cursorIndex));
            }
            this.status = 3;
        }
        return this;
    }

    public synchronized boolean previousRow() throws IOException {
        if (this.row > 0) {
            Pair<Integer, Integer> next;
            int previousRow;
            int previousOffset = 0;
            int previousIndex = 0;
            for (previousRow = 0; previousRow < this.row - 1 && (next = this.nextRow(previousOffset, previousIndex, this.width)) != null; ++previousRow) {
                previousOffset = next.getFirst();
                previousIndex = next.getSecond();
            }
            this.status = 0;
            this.cursorY = 0;
            this.cursorX = 0;
            this.cursorOffset = this.offset = previousOffset;
            this.cursorIndex = this.index = previousIndex;
            this.row = previousRow;
            return true;
        }
        return false;
    }

    public synchronized boolean isPainted() {
        return this.status == 3;
    }

    public synchronized boolean isRefresh() {
        return this.status == 0;
    }

    public synchronized boolean isPainting() {
        return this.status == 1;
    }

    public synchronized boolean nextRow() throws IOException {
        return this.scroll(1) == 1;
    }

    public synchronized int nextPage() throws IOException {
        return this.scroll(this.height);
    }

    private int scroll(int amount) throws IOException {
        if (amount < 0) {
            throw new UnsupportedOperationException("Not implemented for negative operations");
        }
        if (amount == 0) {
            return 0;
        }
        if (this.isPainted()) {
            int count;
            int _offset = this.cursorOffset;
            int _index = this.cursorIndex;
            for (count = 0; count < amount; ++count) {
                Pair<Integer, Integer> next = this.nextRow(_offset, _index, this.width);
                if (next != null) {
                    _offset = next.getFirst();
                    _index = next.getSecond();
                    continue;
                }
                if (this.nextRow(_offset, _index, 1) == null) break;
                ++count;
                break;
            }
            if (count > 0) {
                _offset = this.offset;
                _index = this.index;
                for (int i = 0; i < count; ++i) {
                    Pair<Integer, Integer> next = this.nextRow(_offset, _index, this.width);
                    _offset = next.getFirst();
                    _index = next.getSecond();
                }
                this.status = 0;
                this.cursorY = 0;
                this.cursorX = 0;
                this.cursorOffset = this.offset = _offset;
                this.cursorIndex = this.index = _index;
                this.row += count;
            }
            return count;
        }
        return 0;
    }

    private Pair<Integer, Integer> nextRow(int offset, int index, int width) {
        int count = 0;
        while (true) {
            char c;
            if (index >= this.buffer.get((int)offset).text.length()) {
                if (offset + 1 >= this.buffer.size()) {
                    return null;
                }
                index = 0;
                ++offset;
                continue;
            }
            if ((c = this.buffer.get((int)offset).text.charAt(index++)) == '\n') {
                return new Pair<Integer, Integer>(offset, index);
            }
            if (c >= ' ' && ++count == width) break;
        }
        return new Pair<Integer, Integer>(offset, index);
    }

    public synchronized boolean update() throws IOException {
        int nextWidth = this.out.getWidth();
        int nextHeight = this.out.getHeight();
        if (this.width != nextWidth || this.height != nextHeight) {
            this.width = nextWidth;
            this.height = nextHeight;
            if (this.buffer.size() > 0) {
                this.cursorIndex = this.index;
                this.cursorOffset = this.offset;
                this.cursorX = 0;
                this.cursorY = 0;
                this.status = 0;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.out.flush();
    }

    private static class Foo {
        final CharSequence text;
        final Style style;

        private Foo(CharSequence text, Style style) {
            this.text = text;
            this.style = style;
        }
    }
}

