/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text;

import com.taobao.text.Color;
import com.taobao.text.ScreenContext;
import com.taobao.text.Screenable;
import com.taobao.text.Style;
import java.io.IOException;
import java.util.LinkedList;

public class RenderAppendable
implements ScreenContext {
    private final ScreenContext context;
    private LinkedList<Style.Composite> stack;

    public RenderAppendable(ScreenContext context) {
        this.context = context;
    }

    @Override
    public RenderAppendable append(CharSequence s2) {
        try {
            this.context.append(s2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Screenable append(char c) {
        try {
            this.context.append(c);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Screenable append(CharSequence csq, int start, int end) {
        try {
            this.context.append(csq, start, end);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Screenable append(Style style) {
        try {
            this.context.append(style);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Screenable cls() {
        try {
            this.context.cls();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public int getWidth() {
        return Math.max(0, this.context.getWidth() - 1);
    }

    @Override
    public int getHeight() {
        return this.context.getHeight();
    }

    @Override
    public void flush() throws IOException {
        this.context.flush();
    }

    public void enterStyle(Style.Composite style) {
        if (this.stack == null) {
            this.stack = new LinkedList();
        }
        this.append(style);
        this.stack.addLast(style);
    }

    public Style.Composite leaveStyle() {
        if (this.stack == null || this.stack.isEmpty()) {
            throw new IllegalStateException("Cannot leave non existing style");
        }
        Style.Composite last = this.stack.removeLast();
        if (this.stack.size() > 0) {
            Style.Composite merged = this.getMerged();
            Boolean bold = this.foo(last.getBold(), merged.getBold());
            Boolean underline = this.foo(last.getUnderline(), merged.getUnderline());
            Boolean blink = this.foo(last.getBlink(), merged.getBlink());
            Color fg = this.foo(last.getForeground(), merged.getForeground(), Color.def);
            Color bg = this.foo(last.getBackground(), merged.getBackground(), Color.def);
            Style.Composite bilto = Style.style(bold, underline, blink, fg, bg);
            this.append(bilto);
        } else {
            this.append(Style.reset);
        }
        return last;
    }

    private Style.Composite getMerged() {
        Style.Composite merged = Style.style();
        for (Style style : this.stack) {
            merged = (Style.Composite)merged.merge(style);
        }
        return merged;
    }

    private Boolean foo(Boolean last, Boolean merged) {
        if (last != null) {
            if (merged != null) {
                return merged;
            }
            return last == false;
        }
        return null;
    }

    private Color foo(Color last, Color merged, Color def) {
        if (last != null) {
            if (merged != null) {
                return merged;
            }
            return def;
        }
        return null;
    }

    public void styleOff() {
        if (this.stack != null && this.stack.size() > 0) {
            this.append(Style.reset);
        }
    }

    public void styleOn() {
        if (this.stack != null && this.stack.size() > 0) {
            this.append(this.getMerged());
        }
    }
}

