/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.util;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.util.AttributeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpAuthExtractor {
    private static final Logger logger = LoggerFactory.getLogger(McpAuthExtractor.class);
    public static final String MCP_AUTH_SUBJECT_KEY = "mcp.auth.subject";
    public static final String MCP_USER_ID_KEY = "mcp.user.id";
    public static final String USER_ID_HEADER = "X-User-Id";
    public static final AttributeKey<Object> SUBJECT_ATTRIBUTE_KEY = AttributeKey.valueOf("arthas.auth.subject");

    public static Object extractAuthSubjectFromContext(ChannelHandlerContext ctx) {
        if (ctx == null || ctx.channel() == null) {
            return null;
        }
        try {
            Object subject = ctx.channel().attr(SUBJECT_ATTRIBUTE_KEY).get();
            if (subject != null) {
                logger.debug("Extracted auth subject from channel context: {}", (Object)subject.getClass().getSimpleName());
                return subject;
            }
        }
        catch (Exception e) {
            logger.debug("Failed to extract auth subject from context: {}", (Object)e.getMessage());
        }
        return null;
    }

    public static String extractUserIdFromRequest(FullHttpRequest request) {
        if (request == null) {
            return null;
        }
        String userId = request.headers().get(USER_ID_HEADER);
        if (userId != null && !userId.trim().isEmpty()) {
            logger.debug("Extracted userId from HTTP header {}: {}", (Object)USER_ID_HEADER, (Object)userId);
            return userId.trim();
        }
        return null;
    }
}

