/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.taobao.arthas.mcp.server.protocol.spec.McpSession;
import com.taobao.arthas.mcp.server.util.Assert;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepAliveScheduler {
    private static final Logger logger = LoggerFactory.getLogger(KeepAliveScheduler.class);
    private static final TypeReference<Object> OBJECT_TYPE_REF = new TypeReference<Object>(){};
    private final Duration initialDelay;
    private final Duration interval;
    private final ScheduledExecutorService scheduler;
    private final boolean ownsExecutor;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private volatile ScheduledFuture<?> currentTask;
    private final Supplier<? extends Collection<? extends McpSession>> mcpSessions;

    private KeepAliveScheduler(ScheduledExecutorService scheduler, boolean ownsExecutor, Duration initialDelay, Duration interval, Supplier<? extends Collection<? extends McpSession>> mcpSessions) {
        this.scheduler = scheduler;
        this.ownsExecutor = ownsExecutor;
        this.initialDelay = initialDelay;
        this.interval = interval;
        this.mcpSessions = mcpSessions;
    }

    public static Builder builder(Supplier<? extends Collection<? extends McpSession>> mcpSessions) {
        return new Builder(mcpSessions);
    }

    public KeepAliveScheduler start() {
        if (this.isRunning.compareAndSet(false, true)) {
            logger.debug("Starting KeepAlive scheduler with initial delay: {}ms, interval: {}ms", (Object)this.initialDelay.toMillis(), (Object)this.interval.toMillis());
            this.currentTask = this.scheduler.scheduleAtFixedRate(this::sendKeepAlivePings, this.initialDelay.toMillis(), this.interval.toMillis(), TimeUnit.MILLISECONDS);
            return this;
        }
        throw new IllegalStateException("KeepAlive scheduler is already running. Stop it first.");
    }

    private void sendKeepAlivePings() {
        try {
            Collection<? extends McpSession> sessions = this.mcpSessions.get();
            if (sessions == null || sessions.isEmpty()) {
                logger.trace("No active sessions to ping");
                return;
            }
            logger.trace("Sending keep-alive pings to {} sessions", (Object)sessions.size());
            for (McpSession mcpSession : sessions) {
                try {
                    mcpSession.sendRequest("ping", null, OBJECT_TYPE_REF).whenComplete((result, error) -> {
                        if (error != null) {
                            logger.warn("Failed to send keep-alive ping to session {}: {}", (Object)session, (Object)error.getMessage());
                        } else {
                            logger.trace("Keep-alive ping sent successfully to session {}", (Object)session);
                        }
                    });
                }
                catch (Exception e) {
                    logger.warn("Exception while sending keep-alive ping to session {}: {}", (Object)mcpSession, (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error("Error during keep-alive ping cycle", e);
        }
    }

    public void stop() {
        if (this.currentTask != null && !this.currentTask.isCancelled()) {
            this.currentTask.cancel(false);
            logger.debug("KeepAlive scheduler stopped");
        }
        this.isRunning.set(false);
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public void shutdown() {
        this.stop();
        if (this.ownsExecutor && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
            logger.debug("KeepAlive scheduler executor shut down");
        }
    }

    public static class Builder {
        private ScheduledExecutorService scheduler;
        private boolean ownsExecutor = false;
        private Duration initialDelay = Duration.ofSeconds(0L);
        private Duration interval = Duration.ofSeconds(30L);
        private Supplier<? extends Collection<? extends McpSession>> mcpSessions;

        Builder(Supplier<? extends Collection<? extends McpSession>> mcpSessions) {
            Assert.notNull(mcpSessions, "McpSessions supplier must not be null");
            this.mcpSessions = mcpSessions;
        }

        public Builder scheduler(ScheduledExecutorService scheduler) {
            Assert.notNull(scheduler, "Scheduler must not be null");
            this.scheduler = scheduler;
            this.ownsExecutor = false;
            return this;
        }

        public Builder initialDelay(Duration initialDelay) {
            Assert.notNull(initialDelay, "Initial delay must not be null");
            this.initialDelay = initialDelay;
            return this;
        }

        public Builder interval(Duration interval) {
            Assert.notNull(interval, "Interval must not be null");
            this.interval = interval;
            return this;
        }

        public KeepAliveScheduler build() {
            if (this.scheduler == null) {
                this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
                    Thread t = new Thread(r, "mcp-keep-alive-scheduler");
                    t.setDaemon(true);
                    return t;
                });
                this.ownsExecutor = true;
            }
            return new KeepAliveScheduler(this.scheduler, this.ownsExecutor, this.initialDelay, this.interval, this.mcpSessions);
        }
    }
}

