/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.tool.function;

import com.taobao.arthas.mcp.server.protocol.server.McpNettyServerExchange;
import com.taobao.arthas.mcp.server.protocol.spec.McpSchema;
import com.taobao.arthas.mcp.server.session.ArthasCommandContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamableToolUtils {
    private static final Logger logger = LoggerFactory.getLogger(StreamableToolUtils.class);
    private static final int DEFAULT_POLL_INTERVAL_MS = 100;
    private static final int ERROR_RETRY_INTERVAL_MS = 500;
    private static final int MAX_POLL_ATTEMPTS = 20;
    private static final int MAX_ERROR_RETRIES = 10;
    public static final int MIN_ALLOW_INPUT_COUNT_TO_COMPLETE = 2;

    private StreamableToolUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> executeAndCollectResults(McpNettyServerExchange exchange, ArthasCommandContext commandContext, Integer expectedResultCount, Integer intervalMs, String progressToken) {
        ArrayList<Object> allResults = new ArrayList<Object>();
        int pollAttempts = 0;
        int errorRetries = 0;
        int allowInputCount = 0;
        int totalResultCount = 0;
        int pullIntervalMs = intervalMs != null && intervalMs > 0 ? intervalMs : 100;
        try {
            boolean bl;
            while (pollAttempts < 20) {
                ++pollAttempts;
                try {
                    String jobStatus;
                    boolean commandCompleted;
                    Map<String, Object> results = commandContext.pullResults();
                    if (results == null) {
                        Thread.sleep(pullIntervalMs);
                        continue;
                    }
                    errorRetries = 0;
                    String errorMessage = StreamableToolUtils.checkForErrorMessages(results);
                    if (errorMessage != null) {
                        logger.warn("Command execution failed with error: {}", (Object)errorMessage);
                        return StreamableToolUtils.createErrorResponseWithResults(errorMessage, allResults, totalResultCount);
                    }
                    Map<String, Object> filteredResults = StreamableToolUtils.filterCommandSpecificResults(results);
                    List<Object> currentBatchResults = StreamableToolUtils.getCommandSpecificResults(filteredResults);
                    if (currentBatchResults != null && !currentBatchResults.isEmpty()) {
                        allResults.addAll(currentBatchResults);
                        logger.debug("Collected {} results, total: {}", (Object)currentBatchResults.size(), (Object)(totalResultCount += currentBatchResults.size()));
                        if (exchange != null) {
                            StreamableToolUtils.sendProgressNotification(exchange, totalResultCount, expectedResultCount != null ? expectedResultCount : totalResultCount, progressToken);
                        }
                    }
                    if (commandCompleted = StreamableToolUtils.checkCommandCompletion(results, allowInputCount)) {
                        ++allowInputCount;
                    }
                    if (!"TERMINATED".equals(jobStatus = (String)results.get("jobStatus")) && (!commandCompleted || allowInputCount < 2) && (expectedResultCount == null || totalResultCount < expectedResultCount)) continue;
                    logger.info("Command completed. Total results collected: {}, Expected: {}", (Object)totalResultCount, (Object)expectedResultCount);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("Command execution interrupted");
                    return null;
                }
                catch (Exception e) {
                    if (++errorRetries >= 10) {
                        logger.error("Maximum error retries exceeded", e);
                        return null;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
            }
            if (pollAttempts >= 20) {
                bl = true;
                return StreamableToolUtils.createFinalResult(allResults, totalResultCount, bl);
            }
            bl = false;
            return StreamableToolUtils.createFinalResult(allResults, totalResultCount, bl);
        }
        catch (Exception e) {
            logger.error("Error in command execution", e);
            return null;
        }
    }

    private static boolean checkCommandCompletion(Map<String, Object> results, int currentAllowInputCount) {
        if (results == null) {
            return false;
        }
        List resultList = (List)results.get("results");
        if (resultList == null || resultList.isEmpty()) {
            return false;
        }
        for (Object result : resultList) {
            if (!"com.taobao.arthas.mcp.server.model.InputStatusModel".equals(result.getClass().getName())) continue;
            try {
                String inputStatusName;
                Method getInputStatusMethod = result.getClass().getMethod("getInputStatus", new Class[0]);
                Object inputStatusObj = getInputStatusMethod.invoke(result, new Object[0]);
                if (inputStatusObj == null || !"ALLOW_INPUT".equals(inputStatusName = inputStatusObj.getClass().getSimpleName().equals("InputStatus") ? inputStatusObj.toString() : String.valueOf(inputStatusObj))) continue;
                logger.debug("Command completion detected via InputStatusModel: ALLOW_INPUT (count: {})", (Object)(currentAllowInputCount + 1));
                return true;
            }
            catch (Exception e) {
                logger.debug("Failed to get inputStatus from InputStatusModel", e);
            }
        }
        return false;
    }

    private static String checkForErrorMessages(Map<String, Object> results) {
        if (results == null) {
            return null;
        }
        List resultList = (List)results.get("results");
        if (resultList == null || resultList.isEmpty()) {
            return null;
        }
        for (Object result : resultList) {
            String resultClassName = result.getClass().getName();
            if (!"com.taobao.arthas.mcp.server.model.MessageModel".equals(resultClassName) && !"com.taobao.arthas.mcp.server.model.EnhancerModel".equals(resultClassName) && !"com.taobao.arthas.mcp.server.model.StatusModel".equals(resultClassName) && !"com.taobao.arthas.mcp.server.model.CommandRequestModel".equals(resultClassName)) continue;
            try {
                String message;
                Method getMessageMethod = result.getClass().getMethod("getMessage", new Class[0]);
                Object messageObj = getMessageMethod.invoke(result, new Object[0]);
                if (messageObj == null || !(message = String.valueOf(messageObj)).matches(".*\\b(failed|error|exception)\\b.*") && !message.contains("Malformed OGNL expression") && !message.contains("ParseException") && !message.contains("ExpressionSyntaxException") && !message.matches(".*Exception.*") && !message.matches(".*Error.*")) continue;
                return message;
            }
            catch (Exception e) {
                logger.debug("Failed to get message from {}", (Object)resultClassName, (Object)e);
            }
        }
        return null;
    }

    private static Map<String, Object> filterCommandSpecificResults(Map<String, Object> results) {
        if (results == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> filteredResults = new HashMap<String, Object>(results);
        List resultList = (List)results.get("results");
        if (resultList == null || resultList.isEmpty()) {
            return filteredResults;
        }
        String[] auxiliaryModelTypes = new String[]{"InputStatusModel", "StatusModel", "WelcomeModel", "MessageModel", "CommandRequestModel", "SessionModel", "EnhancerModel"};
        List filteredResultList = resultList.stream().filter(result -> {
            String resultClassName = result.getClass().getSimpleName();
            for (String auxiliaryType : auxiliaryModelTypes) {
                if (!resultClassName.equals(auxiliaryType)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        filteredResults.put("results", filteredResultList);
        filteredResults.put("resultCount", filteredResultList.size());
        return filteredResults;
    }

    private static List<Object> getCommandSpecificResults(Map<String, Object> filteredResults) {
        if (filteredResults == null) {
            return new ArrayList<Object>();
        }
        List resultList = (List)filteredResults.get("results");
        return resultList != null ? resultList : new ArrayList();
    }

    private static void sendProgressNotification(McpNettyServerExchange exchange, int currentResultCount, int totalExpected, String progressToken) {
        try {
            if (progressToken != null && !progressToken.trim().isEmpty()) {
                exchange.progressNotification(new McpSchema.ProgressNotification(progressToken, currentResultCount, Double.valueOf(totalExpected))).join();
            }
        }
        catch (Exception e) {
            logger.error("Error sending progress notification", e);
        }
    }

    public static Map<String, Object> createErrorResponse(String message) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("error", true);
        response.put("message", message);
        response.put("status", "error");
        response.put("stage", "final");
        return response;
    }

    public static Map<String, Object> createErrorResponseWithResults(String message, List<Object> collectedResults, int resultCount) {
        Map<String, Object> response = StreamableToolUtils.createErrorResponse(message);
        response.put("results", collectedResults != null ? collectedResults : new ArrayList());
        response.put("resultCount", resultCount);
        return response;
    }

    private static Map<String, Object> createFinalResult(List<Object> allResults, int totalResultCount, boolean reachedMaxAttempts) {
        HashMap<String, Object> finalResult = new HashMap<String, Object>();
        finalResult.put("results", allResults);
        finalResult.put("resultCount", totalResultCount);
        finalResult.put("status", "completed");
        finalResult.put("stage", "final");
        if (reachedMaxAttempts) {
            logger.warn("Command execution reached maximum poll attempts: {}", (Object)20);
            finalResult.put("warning", "Execution reached maximum poll attempts");
        }
        return finalResult;
    }

    public static Map<String, Object> createCompletedResponse(String message, Map<String, Object> results) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", "completed");
        response.put("message", message);
        response.put("stage", "final");
        if (results != null) {
            response.putAll(results);
        }
        return response;
    }
}

