/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.protocol.spec;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.taobao.arthas.mcp.server.util.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class McpSchema {
    private static final Logger logger = LoggerFactory.getLogger(McpSchema.class);
    public static final String LATEST_PROTOCOL_VERSION = "2025-06-18";
    public static final String JSONRPC_VERSION = "2.0";
    public static final String METHOD_INITIALIZE = "initialize";
    public static final String METHOD_NOTIFICATION_INITIALIZED = "notifications/initialized";
    public static final String METHOD_PING = "ping";
    public static final String METHOD_NOTIFICATION_PROGRESS = "notifications/progress";
    public static final String METHOD_TOOLS_LIST = "tools/list";
    public static final String METHOD_TOOLS_CALL = "tools/call";
    public static final String METHOD_NOTIFICATION_TOOLS_LIST_CHANGED = "notifications/tools/list_changed";
    public static final String METHOD_RESOURCES_LIST = "resources/list";
    public static final String METHOD_RESOURCES_READ = "resources/read";
    public static final String METHOD_NOTIFICATION_RESOURCES_LIST_CHANGED = "notifications/resources/list_changed";
    public static final String METHOD_RESOURCES_TEMPLATES_LIST = "resources/templates/list";
    public static final String METHOD_PROMPT_LIST = "prompts/list";
    public static final String METHOD_PROMPT_GET = "prompts/get";
    public static final String METHOD_NOTIFICATION_PROMPTS_LIST_CHANGED = "notifications/prompts/list_changed";
    public static final String METHOD_LOGGING_SET_LEVEL = "logging/setLevel";
    public static final String METHOD_NOTIFICATION_MESSAGE = "notifications/message";
    public static final String METHOD_ROOTS_LIST = "roots/list";
    public static final String METHOD_NOTIFICATION_ROOTS_LIST_CHANGED = "notifications/roots/list_changed";
    public static final String METHOD_SAMPLING_CREATE_MESSAGE = "sampling/createMessage";
    public static final String METHOD_ELICITATION_CREATE = "elicitation/create";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<HashMap<String, Object>> MAP_TYPE_REF = new TypeReference<HashMap<String, Object>>(){};

    private McpSchema() {
    }

    public static JSONRPCMessage deserializeJsonRpcMessage(ObjectMapper objectMapper, String jsonText) throws IOException {
        logger.debug("Received JSON message: {}", (Object)jsonText);
        Map map = objectMapper.readValue(jsonText, MAP_TYPE_REF);
        if (map.containsKey("method") && map.containsKey("id")) {
            return objectMapper.convertValue((Object)map, JSONRPCRequest.class);
        }
        if (map.containsKey("method") && !map.containsKey("id")) {
            return objectMapper.convertValue((Object)map, JSONRPCNotification.class);
        }
        if (map.containsKey("result") || map.containsKey("error")) {
            return objectMapper.convertValue((Object)map, JSONRPCResponse.class);
        }
        throw new IllegalArgumentException("Cannot deserialize JSONRPCMessage: " + jsonText);
    }

    private static JsonSchema parseSchema(String schema) {
        try {
            return OBJECT_MAPPER.readValue(schema, JsonSchema.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid schema: " + schema, e);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListRootsResult
    implements Result {
        private final List<Root> roots;

        public ListRootsResult(@JsonProperty(value="roots") List<Root> roots2) {
            this.roots = roots2;
        }

        public List<Root> getRoots() {
            return this.roots;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Root {
        private final String uri;
        private final String name;

        public Root(@JsonProperty(value="uri") String uri, @JsonProperty(value="name") String name) {
            this.uri = uri;
            this.name = name;
        }

        public String getUri() {
            return this.uri;
        }

        public String getName() {
            return this.name;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class EmbeddedResource
    implements Content {
        private final List<Role> audience;
        private final Double priority;
        private final ResourceContents resource;

        public EmbeddedResource(@JsonProperty(value="audience") List<Role> audience, @JsonProperty(value="priority") Double priority, @JsonProperty(value="resource") ResourceContents resource) {
            this.audience = audience;
            this.priority = priority;
            this.resource = resource;
        }

        @Override
        public String type() {
            return "resource";
        }

        public List<Role> getAudience() {
            return this.audience;
        }

        public Double getPriority() {
            return this.priority;
        }

        public ResourceContents getResource() {
            return this.resource;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ImageContent
    implements Content {
        private final List<Role> audience;
        private final Double priority;
        private final String data;
        private final String mimeType;

        public ImageContent(@JsonProperty(value="audience") List<Role> audience, @JsonProperty(value="priority") Double priority, @JsonProperty(value="data") String data, @JsonProperty(value="mimeType") String mimeType) {
            this.audience = audience;
            this.priority = priority;
            this.data = data;
            this.mimeType = mimeType;
        }

        @Override
        public String type() {
            return "image";
        }

        public List<Role> getAudience() {
            return this.audience;
        }

        public Double getPriority() {
            return this.priority;
        }

        public String getData() {
            return this.data;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TextContent
    implements Content {
        private final List<Role> audience;
        private final Double priority;
        private final String text;

        public TextContent(@JsonProperty(value="audience") List<Role> audience, @JsonProperty(value="priority") Double priority, @JsonProperty(value="text") String text) {
            this.audience = audience;
            this.priority = priority;
            this.text = text;
        }

        public TextContent(String content) {
            this(null, null, content);
        }

        public List<Role> getAudience() {
            return this.audience;
        }

        public Double getPriority() {
            return this.priority;
        }

        public String getText() {
            return this.text;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextContent.class, name="text"), @JsonSubTypes.Type(value=ImageContent.class, name="image"), @JsonSubTypes.Type(value=EmbeddedResource.class, name="resource")})
    public static interface Content {
        default public String type() {
            if (this instanceof TextContent) {
                return "text";
            }
            if (this instanceof ImageContent) {
                return "image";
            }
            if (this instanceof EmbeddedResource) {
                return "resource";
            }
            throw new IllegalArgumentException("Unknown content type: " + this);
        }
    }

    public static class CompleteCompletion {
        private final List<String> values;
        private final Integer total;
        private final Boolean hasMore;

        public CompleteCompletion(@JsonProperty(value="values") List<String> values2, @JsonProperty(value="total") Integer total, @JsonProperty(value="hasMore") Boolean hasMore) {
            this.values = values2;
            this.total = total;
            this.hasMore = hasMore;
        }

        public List<String> getValues() {
            return this.values;
        }

        public Integer getTotal() {
            return this.total;
        }

        public Boolean getHasMore() {
            return this.hasMore;
        }
    }

    public static class CompleteResult
    implements Result {
        private final CompleteCompletion completion;

        public CompleteResult(@JsonProperty(value="completion") CompleteCompletion completion) {
            this.completion = completion;
        }

        public CompleteCompletion getCompletion() {
            return this.completion;
        }
    }

    public static class CompleteRequest
    implements Request {
        private final PromptOrResourceReference ref;
        private final CompleteArgument argument;

        public CompleteRequest(@JsonProperty(value="ref") PromptOrResourceReference ref, @JsonProperty(value="argument") CompleteArgument argument) {
            this.ref = ref;
            this.argument = argument;
        }

        public PromptOrResourceReference getRef() {
            return this.ref;
        }

        public CompleteArgument getArgument() {
            return this.argument;
        }

        public static class ResourceReference
        extends PromptOrResourceReference {
            private final String uri;

            public ResourceReference(@JsonProperty(value="type") String type, @JsonProperty(value="uri") String uri) {
                super(type);
                this.uri = uri;
            }

            public String getUri() {
                return this.uri;
            }
        }

        public static class PromptReference
        extends PromptOrResourceReference {
            private final String name;

            public PromptReference(@JsonProperty(value="type") String type, @JsonProperty(value="name") String name) {
                super(type);
                this.name = name;
            }

            public String getName() {
                return this.name;
            }
        }

        public static class PromptOrResourceReference {
            private final String type;

            public PromptOrResourceReference(@JsonProperty(value="type") String type) {
                this.type = type;
            }

            public String getType() {
                return this.type;
            }
        }
    }

    public static enum CompleteArgument {
        NAME,
        DESCRIPTION,
        URI,
        MIME_TYPE;

    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class IntermediateResultNotification {
        private final String type;
        private final Object data;

        public IntermediateResultNotification(@JsonProperty(value="type") String type, @JsonProperty(value="data") Object data) {
            this.type = type;
            this.data = data;
        }

        public String getType() {
            return this.type;
        }

        public Object getData() {
            return this.data;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SetLevelRequest {
        private final LoggingLevel level;

        public SetLevelRequest(@JsonProperty(value="level") LoggingLevel level) {
            this.level = level;
        }

        public LoggingLevel getLevel() {
            return this.level;
        }
    }

    public static enum LoggingLevel {
        DEBUG(0),
        INFO(1),
        NOTICE(2),
        WARNING(3),
        ERROR(4),
        CRITICAL(5),
        ALERT(6),
        EMERGENCY(7);

        private final int level;

        private LoggingLevel(int level) {
            this.level = level;
        }

        public int level() {
            return this.level;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LoggingMessageNotification {
        private final LoggingLevel level;
        private final String logger;
        private final Object data;

        public LoggingMessageNotification(@JsonProperty(value="level") LoggingLevel level, @JsonProperty(value="logger") String logger, @JsonProperty(value="data") Object data) {
            this.level = level;
            this.logger = logger;
            this.data = data;
        }

        public LoggingLevel getLevel() {
            return this.level;
        }

        public String getLogger() {
            return this.logger;
        }

        public Object getData() {
            return this.data;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private LoggingLevel level = LoggingLevel.INFO;
            private String logger = "server";
            private Object data;

            public Builder level(LoggingLevel level) {
                this.level = level;
                return this;
            }

            public Builder logger(String logger) {
                this.logger = logger;
                return this;
            }

            public Builder data(Object data) {
                this.data = data;
                return this;
            }

            public LoggingMessageNotification build() {
                return new LoggingMessageNotification(this.level, this.logger, this.data);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ProgressNotification {
        private final String progressToken;
        private final double progress;
        private final Double total;

        public ProgressNotification(@JsonProperty(value="progressToken") String progressToken, @JsonProperty(value="progress") double progress, @JsonProperty(value="total") Double total) {
            this.progressToken = progressToken;
            this.progress = progress;
            this.total = total;
        }

        public String getProgressToken() {
            return this.progressToken;
        }

        public double getProgress() {
            return this.progress;
        }

        public Double getTotal() {
            return this.total;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PaginatedResult {
        private final String nextCursor;

        public PaginatedResult(@JsonProperty(value="nextCursor") String nextCursor) {
            this.nextCursor = nextCursor;
        }

        public String getNextCursor() {
            return this.nextCursor;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PaginatedRequest {
        private final String cursor;

        public PaginatedRequest(@JsonProperty(value="cursor") String cursor) {
            this.cursor = cursor;
        }

        public String getCursor() {
            return this.cursor;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ElicitResult
    implements Result {
        private final Action action;
        private final Map<String, Object> content;
        private final Map<String, Object> meta;

        public ElicitResult(@JsonProperty(value="action") Action action, @JsonProperty(value="content") Map<String, Object> content, @JsonProperty(value="_meta") Map<String, Object> meta) {
            this.action = action;
            this.content = content;
            this.meta = meta;
        }

        public Action getAction() {
            return this.action;
        }

        public Map<String, Object> getContent() {
            return this.content;
        }

        @Override
        public Map<String, Object> meta() {
            return this.meta;
        }

        public Map<String, Object> getMeta() {
            return this.meta();
        }

        public ElicitResult(Action action, Map<String, Object> content) {
            this(action, content, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Action action;
            private Map<String, Object> content;
            private Map<String, Object> meta;

            public Builder action(Action action) {
                this.action = action;
                return this;
            }

            public Builder content(Map<String, Object> content) {
                this.content = content;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public ElicitResult build() {
                return new ElicitResult(this.action, this.content, this.meta);
            }
        }

        public static enum Action {
            ACCEPT,
            DECLINE,
            CANCEL;

        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ElicitRequest
    implements Request {
        private final String message;
        private final Map<String, Object> requestedSchema;
        private final Map<String, Object> meta;

        public ElicitRequest(@JsonProperty(value="message") String message, @JsonProperty(value="requestedSchema") Map<String, Object> requestedSchema, @JsonProperty(value="_meta") Map<String, Object> meta) {
            this.message = message;
            this.requestedSchema = requestedSchema;
            this.meta = meta;
        }

        public String getMessage() {
            return this.message;
        }

        public Map<String, Object> getRequestedSchema() {
            return this.requestedSchema;
        }

        @Override
        public Map<String, Object> meta() {
            return this.meta;
        }

        public Map<String, Object> getMeta() {
            return this.meta();
        }

        public ElicitRequest(String message, Map<String, Object> requestedSchema) {
            this(message, requestedSchema, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String message;
            private Map<String, Object> requestedSchema;
            private Map<String, Object> meta;

            public Builder message(String message) {
                this.message = message;
                return this;
            }

            public Builder requestedSchema(Map<String, Object> requestedSchema) {
                this.requestedSchema = requestedSchema;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public Builder progressToken(Object progressToken) {
                if (this.meta == null) {
                    this.meta = new HashMap<String, Object>();
                }
                this.meta.put("progressToken", progressToken);
                return this;
            }

            public ElicitRequest build() {
                return new ElicitRequest(this.message, this.requestedSchema, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateMessageResult
    implements Result {
        private final Role role;
        private final Content content;
        private final String model;
        private final StopReason stopReason;

        public CreateMessageResult(@JsonProperty(value="role") Role role, @JsonProperty(value="content") Content content, @JsonProperty(value="model") String model, @JsonProperty(value="stopReason") StopReason stopReason) {
            this.role = role;
            this.content = content;
            this.model = model;
            this.stopReason = stopReason;
        }

        public Role getRole() {
            return this.role;
        }

        public Content getContent() {
            return this.content;
        }

        public String getModel() {
            return this.model;
        }

        public StopReason getStopReason() {
            return this.stopReason;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateMessageRequest
    implements Request {
        private final List<SamplingMessage> messages;
        private final ModelPreferences modelPreferences;
        private final String systemPrompt;
        private final ContextInclusionStrategy includeContext;
        private final Double temperature;
        private final int maxTokens;
        private final List<String> stopSequences;
        private final Map<String, Object> meta;

        public CreateMessageRequest(@JsonProperty(value="messages") List<SamplingMessage> messages, @JsonProperty(value="modelPreferences") ModelPreferences modelPreferences, @JsonProperty(value="systemPrompt") String systemPrompt, @JsonProperty(value="includeContext") ContextInclusionStrategy includeContext, @JsonProperty(value="temperature") Double temperature, @JsonProperty(value="maxTokens") int maxTokens, @JsonProperty(value="stopSequences") List<String> stopSequences, @JsonProperty(value="_meta") Map<String, Object> meta) {
            this.messages = messages;
            this.modelPreferences = modelPreferences;
            this.systemPrompt = systemPrompt;
            this.includeContext = includeContext;
            this.temperature = temperature;
            this.maxTokens = maxTokens;
            this.stopSequences = stopSequences;
            this.meta = meta;
        }

        public List<SamplingMessage> getMessages() {
            return this.messages;
        }

        public ModelPreferences getModelPreferences() {
            return this.modelPreferences;
        }

        public String getSystemPrompt() {
            return this.systemPrompt;
        }

        public ContextInclusionStrategy getIncludeContext() {
            return this.includeContext;
        }

        public Double getTemperature() {
            return this.temperature;
        }

        public int getMaxTokens() {
            return this.maxTokens;
        }

        public List<String> getStopSequences() {
            return this.stopSequences;
        }

        @Override
        public Map<String, Object> meta() {
            return this.meta;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SamplingMessage {
        private final Role role;
        private final Content content;

        public SamplingMessage(@JsonProperty(value="role") Role role, @JsonProperty(value="content") Content content) {
            this.role = role;
            this.content = content;
        }

        public Role getRole() {
            return this.role;
        }

        public Content getContent() {
            return this.content;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModelHint {
        private final String name;

        public ModelHint(@JsonProperty(value="name") String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModelPreferences {
        private final List<ModelHint> hints;
        private final Double costPriority;
        private final Double speedPriority;
        private final Double intelligencePriority;

        public ModelPreferences(@JsonProperty(value="hints") List<ModelHint> hints, @JsonProperty(value="costPriority") Double costPriority, @JsonProperty(value="speedPriority") Double speedPriority, @JsonProperty(value="intelligencePriority") Double intelligencePriority) {
            this.hints = hints;
            this.costPriority = costPriority;
            this.speedPriority = speedPriority;
            this.intelligencePriority = intelligencePriority;
        }

        public List<ModelHint> getHints() {
            return this.hints;
        }

        public Double getCostPriority() {
            return this.costPriority;
        }

        public Double getSpeedPriority() {
            return this.speedPriority;
        }

        public Double getIntelligencePriority() {
            return this.intelligencePriority;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CallToolResult
    implements Result {
        private final List<Content> content;
        private final Boolean isError;
        private final Map<String, Object> meta;

        public CallToolResult(@JsonProperty(value="content") List<Content> content, @JsonProperty(value="isError") Boolean isError, @JsonProperty(value="_meta") Map<String, Object> meta) {
            this.content = content;
            this.isError = isError;
            this.meta = meta;
        }

        public CallToolResult(String content, Boolean isError, Map<String, Object> meta) {
            this(Collections.singletonList(new TextContent(content)), isError, meta);
        }

        public List<Content> getContent() {
            return this.content;
        }

        public Boolean getIsError() {
            return this.isError;
        }

        @Override
        public Map<String, Object> meta() {
            return this.meta;
        }

        public Map<String, Object> getMeta() {
            return this.meta();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private List<Content> content = new ArrayList<Content>();
            private Boolean isError;
            private Map<String, Object> meta;

            public Builder content(List<Content> content) {
                Assert.notNull(content, "content must not be null");
                this.content = content;
                return this;
            }

            public Builder textContent(List<String> textContent) {
                Assert.notNull(textContent, "textContent must not be null");
                textContent.stream().map(TextContent::new).forEach(this.content::add);
                return this;
            }

            public Builder addContent(Content contentItem) {
                Assert.notNull(contentItem, "contentItem must not be null");
                if (this.content == null) {
                    this.content = new ArrayList<Content>();
                }
                this.content.add(contentItem);
                return this;
            }

            public Builder addTextContent(String text) {
                Assert.notNull(text, "text must not be null");
                return this.addContent(new TextContent(text));
            }

            public Builder isError(Boolean isError) {
                Assert.notNull(isError, "isError must not be null");
                this.isError = isError;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public CallToolResult build() {
                return new CallToolResult(this.content, this.isError, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CallToolRequest
    implements Request {
        private final String name;
        private final Map<String, Object> arguments;
        private final Map<String, Object> meta;

        public CallToolRequest(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") Map<String, Object> arguments, @JsonProperty(value="_meta") Map<String, Object> meta) {
            this.name = name;
            this.arguments = arguments;
            this.meta = meta;
        }

        private static Map<String, Object> parseJsonArguments(String jsonArguments) {
            try {
                return (Map)OBJECT_MAPPER.readValue(jsonArguments, MAP_TYPE_REF);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid arguments: " + jsonArguments, e);
            }
        }

        public String getName() {
            return this.name;
        }

        public Map<String, Object> getArguments() {
            return this.arguments;
        }

        @Override
        public Map<String, Object> meta() {
            return this.meta;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String name;
            private Map<String, Object> arguments;
            private Map<String, Object> meta;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder arguments(Map<String, Object> arguments) {
                this.arguments = arguments;
                return this;
            }

            public Builder arguments(String jsonArguments) {
                this.arguments = CallToolRequest.parseJsonArguments(jsonArguments);
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public Builder progressToken(String progressToken) {
                if (this.meta == null) {
                    this.meta = new HashMap<String, Object>();
                }
                this.meta.put("progressToken", progressToken);
                return this;
            }

            public CallToolRequest build() {
                Assert.hasText(this.name, "name must not be empty");
                return new CallToolRequest(this.name, this.arguments, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Tool {
        private final String name;
        private final String description;
        private final JsonSchema inputSchema;

        public Tool(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="inputSchema") JsonSchema inputSchema) {
            this.name = name;
            this.description = description;
            this.inputSchema = inputSchema;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public JsonSchema getInputSchema() {
            return this.inputSchema;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonSchema {
        private final String type;
        private final Map<String, Object> properties;
        private final List<String> required;
        private final Boolean additionalProperties;

        public JsonSchema(@JsonProperty(value="type") String type, @JsonProperty(value="properties") Map<String, Object> properties, @JsonProperty(value="required") List<String> required, @JsonProperty(value="additionalProperties") Boolean additionalProperties) {
            this.type = type;
            this.properties = properties;
            this.required = required;
            this.additionalProperties = additionalProperties;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public List<String> getRequired() {
            return this.required;
        }

        public Boolean getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListToolsResult
    implements Result {
        private final List<Tool> tools;
        private final String nextCursor;
        private final Map<String, Object> meta;

        public ListToolsResult(@JsonProperty(value="tools") List<Tool> tools, @JsonProperty(value="nextCursor") String nextCursor, @JsonProperty(value="_meta") Map<String, Object> meta) {
            this.tools = tools;
            this.nextCursor = nextCursor;
            this.meta = meta;
        }

        public ListToolsResult(List<Tool> tools, String nextCursor) {
            this(tools, nextCursor, null);
        }

        public List<Tool> getTools() {
            return this.tools;
        }

        public String getNextCursor() {
            return this.nextCursor;
        }

        @Override
        public Map<String, Object> meta() {
            return this.meta;
        }

        public Map<String, Object> getMeta() {
            return this.meta();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetPromptResult
    implements Result {
        private final String description;
        private final List<PromptMessage> messages;
        private final Map<String, Object> meta;

        public GetPromptResult(@JsonProperty(value="description") String description, @JsonProperty(value="messages") List<PromptMessage> messages, @JsonProperty(value="_meta") Map<String, Object> meta) {
            this.description = description;
            this.messages = messages;
            this.meta = meta;
        }

        public GetPromptResult(String description, List<PromptMessage> messages) {
            this(description, messages, null);
        }

        public String getDescription() {
            return this.description;
        }

        public List<PromptMessage> getMessages() {
            return this.messages;
        }

        @Override
        public Map<String, Object> meta() {
            return this.meta;
        }

        public Map<String, Object> getMeta() {
            return this.meta();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetPromptRequest
    implements Request {
        private final String name;
        private final Map<String, Object> arguments;

        public GetPromptRequest(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") Map<String, Object> arguments) {
            this.name = name;
            this.arguments = arguments;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, Object> getArguments() {
            return this.arguments;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListPromptsResult
    implements Result {
        private final List<Prompt> prompts;
        private final String nextCursor;
        private final Map<String, Object> meta;

        public ListPromptsResult(@JsonProperty(value="prompts") List<Prompt> prompts, @JsonProperty(value="nextCursor") String nextCursor, @JsonProperty(value="_meta") Map<String, Object> meta) {
            this.prompts = prompts;
            this.nextCursor = nextCursor;
            this.meta = meta;
        }

        public ListPromptsResult(List<Prompt> prompts, String nextCursor) {
            this(prompts, nextCursor, null);
        }

        public List<Prompt> getPrompts() {
            return this.prompts;
        }

        public String getNextCursor() {
            return this.nextCursor;
        }

        @Override
        public Map<String, Object> meta() {
            return this.meta;
        }

        public Map<String, Object> getMeta() {
            return this.meta();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PromptMessage {
        private final Role role;
        private final Content content;

        public PromptMessage(@JsonProperty(value="role") Role role, @JsonProperty(value="content") Content content) {
            this.role = role;
            this.content = content;
        }

        public Role getRole() {
            return this.role;
        }

        public Content getContent() {
            return this.content;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PromptArgument {
        private final String name;
        private final String description;
        private final Boolean required;

        public PromptArgument(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="required") Boolean required) {
            this.name = name;
            this.description = description;
            this.required = required;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Boolean getRequired() {
            return this.required;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Prompt {
        private final String name;
        private final String description;
        private final List<PromptArgument> arguments;

        public Prompt(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="arguments") List<PromptArgument> arguments) {
            this.name = name;
            this.description = description;
            this.arguments = arguments;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<PromptArgument> getArguments() {
            return this.arguments;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class BlobResourceContents
    implements ResourceContents {
        private final String uri;
        private final String mimeType;
        private final String blob;

        public BlobResourceContents(@JsonProperty(value="uri") String uri, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="blob") String blob) {
            this.uri = uri;
            this.mimeType = mimeType;
            this.blob = blob;
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public String mimeType() {
            return this.mimeType;
        }

        public String getBlob() {
            return this.blob;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TextResourceContents
    implements ResourceContents {
        private final String uri;
        private final String mimeType;
        private final String text;

        public TextResourceContents(@JsonProperty(value="uri") String uri, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="text") String text) {
            this.uri = uri;
            this.mimeType = mimeType;
            this.text = text;
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public String mimeType() {
            return this.mimeType;
        }

        public String getText() {
            return this.text;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.DEDUCTION, include=JsonTypeInfo.As.PROPERTY)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextResourceContents.class, name="text"), @JsonSubTypes.Type(value=BlobResourceContents.class, name="blob")})
    public static interface ResourceContents {
        public String uri();

        public String mimeType();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UnsubscribeRequest {
        private final String uri;

        public UnsubscribeRequest(@JsonProperty(value="uri") String uri) {
            this.uri = uri;
        }

        public String getUri() {
            return this.uri;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SubscribeRequest {
        private final String uri;

        public SubscribeRequest(@JsonProperty(value="uri") String uri) {
            this.uri = uri;
        }

        public String getUri() {
            return this.uri;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ReadResourceResult
    implements Result {
        private final List<ResourceContents> contents;
        private final Map<String, Object> meta;

        public ReadResourceResult(@JsonProperty(value="contents") List<ResourceContents> contents, @JsonProperty(value="_meta") Map<String, Object> meta) {
            this.contents = contents;
            this.meta = meta;
        }

        public ReadResourceResult(List<ResourceContents> contents) {
            this(contents, null);
        }

        public List<ResourceContents> getContents() {
            return this.contents;
        }

        @Override
        public Map<String, Object> meta() {
            return this.meta;
        }

        public Map<String, Object> getMeta() {
            return this.meta();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ReadResourceRequest {
        private final String uri;

        public ReadResourceRequest(@JsonProperty(value="uri") String uri) {
            this.uri = uri;
        }

        public String getUri() {
            return this.uri;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListResourceTemplatesResult
    implements Result {
        private final List<ResourceTemplate> resourceTemplates;
        private final String nextCursor;
        private final Map<String, Object> meta;

        public ListResourceTemplatesResult(@JsonProperty(value="resourceTemplates") List<ResourceTemplate> resourceTemplates, @JsonProperty(value="nextCursor") String nextCursor, @JsonProperty(value="_meta") Map<String, Object> meta) {
            this.resourceTemplates = resourceTemplates;
            this.nextCursor = nextCursor;
            this.meta = meta;
        }

        public ListResourceTemplatesResult(List<ResourceTemplate> resourceTemplates, String nextCursor) {
            this(resourceTemplates, nextCursor, null);
        }

        public List<ResourceTemplate> getResourceTemplates() {
            return this.resourceTemplates;
        }

        public String getNextCursor() {
            return this.nextCursor;
        }

        @Override
        public Map<String, Object> meta() {
            return this.meta;
        }

        public Map<String, Object> getMeta() {
            return this.meta();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListResourcesResult
    implements Result {
        private final List<Resource> resources;
        private final String nextCursor;
        private final Map<String, Object> meta;

        public ListResourcesResult(@JsonProperty(value="resources") List<Resource> resources, @JsonProperty(value="nextCursor") String nextCursor, @JsonProperty(value="_meta") Map<String, Object> meta) {
            this.resources = resources;
            this.nextCursor = nextCursor;
            this.meta = meta;
        }

        public ListResourcesResult(List<Resource> resources, String nextCursor) {
            this(resources, nextCursor, null);
        }

        public List<Resource> getResources() {
            return this.resources;
        }

        public String getNextCursor() {
            return this.nextCursor;
        }

        @Override
        public Map<String, Object> meta() {
            return this.meta;
        }

        public Map<String, Object> getMeta() {
            return this.meta();
        }

        public Object getProgressToken() {
            return this.meta() != null ? this.meta().get("progressToken") : null;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResourceTemplate
    implements Annotated {
        private final String uriTemplate;
        private final String name;
        private final String description;
        private final String mimeType;
        private final Annotations annotations;

        public ResourceTemplate(@JsonProperty(value="uriTemplate") String uriTemplate, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="annotations") Annotations annotations) {
            this.uriTemplate = uriTemplate;
            this.name = name;
            this.description = description;
            this.mimeType = mimeType;
            this.annotations = annotations;
        }

        @Override
        public Annotations annotations() {
            return this.annotations;
        }

        public String getUriTemplate() {
            return this.uriTemplate;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Resource
    implements Annotated {
        private final String uri;
        private final String name;
        private final String description;
        private final String mimeType;
        private final Annotations annotations;

        public Resource(@JsonProperty(value="uri") String uri, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="annotations") Annotations annotations) {
            this.uri = uri;
            this.name = name;
            this.description = description;
            this.mimeType = mimeType;
            this.annotations = annotations;
        }

        @Override
        public Annotations annotations() {
            return this.annotations;
        }

        public String getUri() {
            return this.uri;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Annotations {
        private final List<Role> audience;
        private final Double priority;

        public Annotations(@JsonProperty(value="audience") List<Role> audience, @JsonProperty(value="priority") Double priority) {
            this.audience = audience;
            this.priority = priority;
        }

        public List<Role> getAudience() {
            return this.audience;
        }

        public Double getPriority() {
            return this.priority;
        }
    }

    public static interface Annotated {
        public Annotations annotations();
    }

    public static enum ContextInclusionStrategy {
        NONE,
        ALL,
        RELEVANT;

    }

    public static enum StopReason {
        STOP,
        LENGTH,
        CONTENT_FILTER;

    }

    public static enum Role {
        USER,
        ASSISTANT;

    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Implementation {
        private final String name;
        private final String version;

        public Implementation(@JsonProperty(value="name") String name, @JsonProperty(value="version") String version) {
            this.name = name;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ServerCapabilities {
        private final Map<String, Object> experimental;
        private final LoggingCapabilities logging;
        private final PromptCapabilities prompts;
        private final ResourceCapabilities resources;
        private final ToolCapabilities tools;

        public ServerCapabilities(@JsonProperty(value="experimental") Map<String, Object> experimental, @JsonProperty(value="logging") LoggingCapabilities logging, @JsonProperty(value="prompts") PromptCapabilities prompts, @JsonProperty(value="resources") ResourceCapabilities resources, @JsonProperty(value="tools") ToolCapabilities tools) {
            this.experimental = experimental;
            this.logging = logging;
            this.prompts = prompts;
            this.resources = resources;
            this.tools = tools;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Map<String, Object> getExperimental() {
            return this.experimental;
        }

        public LoggingCapabilities getLogging() {
            return this.logging;
        }

        public PromptCapabilities getPrompts() {
            return this.prompts;
        }

        public ResourceCapabilities getResources() {
            return this.resources;
        }

        public ToolCapabilities getTools() {
            return this.tools;
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public static class ToolCapabilities {
            private final Boolean listChanged;

            public ToolCapabilities(@JsonProperty(value="listChanged") Boolean listChanged) {
                this.listChanged = listChanged;
            }

            public Boolean getListChanged() {
                return this.listChanged;
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public static class ResourceCapabilities {
            private final Boolean subscribe;
            private final Boolean listChanged;

            public ResourceCapabilities(@JsonProperty(value="subscribe") Boolean subscribe, @JsonProperty(value="listChanged") Boolean listChanged) {
                this.subscribe = subscribe;
                this.listChanged = listChanged;
            }

            public Boolean getSubscribe() {
                return this.subscribe;
            }

            public Boolean getListChanged() {
                return this.listChanged;
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public static class PromptCapabilities {
            private final Boolean listChanged;

            public PromptCapabilities(@JsonProperty(value="listChanged") Boolean listChanged) {
                this.listChanged = listChanged;
            }

            public Boolean getListChanged() {
                return this.listChanged;
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public static class LoggingCapabilities {
        }

        public static class Builder {
            private Map<String, Object> experimental;
            private LoggingCapabilities logging;
            private PromptCapabilities prompts;
            private ResourceCapabilities resources;
            private ToolCapabilities tools;

            public Builder experimental(Map<String, Object> experimental) {
                this.experimental = experimental;
                return this;
            }

            public Builder logging(LoggingCapabilities logging) {
                this.logging = logging;
                return this;
            }

            public Builder prompts(PromptCapabilities prompts) {
                this.prompts = prompts;
                return this;
            }

            public Builder resources(ResourceCapabilities resources) {
                this.resources = resources;
                return this;
            }

            public Builder tools(ToolCapabilities tools) {
                this.tools = tools;
                return this;
            }

            public ServerCapabilities build() {
                return new ServerCapabilities(this.experimental, this.logging, this.prompts, this.resources, this.tools);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ClientCapabilities {
        private final Map<String, Object> experimental;
        private final RootCapabilities roots;
        private final Sampling sampling;
        private final Elicitation elicitation;

        public ClientCapabilities(@JsonProperty(value="experimental") Map<String, Object> experimental, @JsonProperty(value="roots") RootCapabilities roots2, @JsonProperty(value="sampling") Sampling sampling, @JsonProperty(value="elicitation") Elicitation elicitation) {
            this.experimental = experimental;
            this.roots = roots2;
            this.sampling = sampling;
            this.elicitation = elicitation;
        }

        public Map<String, Object> getExperimental() {
            return this.experimental;
        }

        public RootCapabilities getRoots() {
            return this.roots;
        }

        public Sampling getSampling() {
            return this.sampling;
        }

        public Elicitation getElicitation() {
            return this.elicitation;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Map<String, Object> experimental;
            private RootCapabilities roots;
            private Sampling sampling;
            private Elicitation elicitation;

            public Builder experimental(Map<String, Object> experimental) {
                this.experimental = experimental;
                return this;
            }

            public Builder roots(Boolean listChanged) {
                this.roots = new RootCapabilities(listChanged);
                return this;
            }

            public Builder sampling() {
                this.sampling = new Sampling();
                return this;
            }

            public Builder elicitation() {
                this.elicitation = new Elicitation();
                return this;
            }

            public ClientCapabilities build() {
                return new ClientCapabilities(this.experimental, this.roots, this.sampling, this.elicitation);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public static class Elicitation {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public static class Sampling {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class RootCapabilities {
            private final Boolean listChanged;

            public RootCapabilities(@JsonProperty(value="listChanged") Boolean listChanged) {
                this.listChanged = listChanged;
            }

            public Boolean getListChanged() {
                return this.listChanged;
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InitializeResult
    implements Result {
        private final String protocolVersion;
        private final ServerCapabilities capabilities;
        private final Implementation serverInfo;
        private final String instructions;

        public InitializeResult(@JsonProperty(value="protocolVersion") String protocolVersion, @JsonProperty(value="capabilities") ServerCapabilities capabilities, @JsonProperty(value="serverInfo") Implementation serverInfo, @JsonProperty(value="instructions") String instructions) {
            this.protocolVersion = protocolVersion;
            this.capabilities = capabilities;
            this.serverInfo = serverInfo;
            this.instructions = instructions;
        }

        public String getProtocolVersion() {
            return this.protocolVersion;
        }

        public ServerCapabilities getCapabilities() {
            return this.capabilities;
        }

        public Implementation getServerInfo() {
            return this.serverInfo;
        }

        public String getInstructions() {
            return this.instructions;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InitializeRequest
    implements Request {
        private final String protocolVersion;
        private final ClientCapabilities capabilities;
        private final Implementation clientInfo;

        public InitializeRequest(@JsonProperty(value="protocolVersion") String protocolVersion, @JsonProperty(value="capabilities") ClientCapabilities capabilities, @JsonProperty(value="clientInfo") Implementation clientInfo) {
            this.protocolVersion = protocolVersion;
            this.capabilities = capabilities;
            this.clientInfo = clientInfo;
        }

        public String getProtocolVersion() {
            return this.protocolVersion;
        }

        public ClientCapabilities getCapabilities() {
            return this.capabilities;
        }

        public Implementation getClientInfo() {
            return this.clientInfo;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JSONRPCResponse
    implements JSONRPCMessage {
        private final String jsonrpc;
        private final Object id;
        private final Object result;
        private final JSONRPCError error;

        public JSONRPCResponse(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="id") Object id, @JsonProperty(value="result") Object result, @JsonProperty(value="error") JSONRPCError error) {
            this.jsonrpc = jsonrpc;
            this.id = id;
            this.result = result;
            this.error = error;
        }

        @Override
        public String getJsonrpc() {
            return this.jsonrpc;
        }

        public Object getId() {
            return this.id;
        }

        public Object getResult() {
            return this.result;
        }

        public JSONRPCError getError() {
            return this.error;
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class JSONRPCError {
            private final int code;
            private final String message;
            private final Object data;

            public JSONRPCError(@JsonProperty(value="code") int code, @JsonProperty(value="message") String message, @JsonProperty(value="data") Object data) {
                this.code = code;
                this.message = message;
                this.data = data;
            }

            public int getCode() {
                return this.code;
            }

            public String getMessage() {
                return this.message;
            }

            public Object getData() {
                return this.data;
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JSONRPCNotification
    implements JSONRPCMessage {
        private final String jsonrpc;
        private final String method;
        private final Object params;

        public JSONRPCNotification(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="method") String method, @JsonProperty(value="params") Object params) {
            this.jsonrpc = jsonrpc;
            this.method = method;
            this.params = params;
        }

        @Override
        public String getJsonrpc() {
            return this.jsonrpc;
        }

        public String getMethod() {
            return this.method;
        }

        public Object getParams() {
            return this.params;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JSONRPCRequest
    implements JSONRPCMessage {
        private final String jsonrpc;
        private final String method;
        private final Object id;
        private final Object params;

        public JSONRPCRequest(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="method") String method, @JsonProperty(value="id") Object id, @JsonProperty(value="params") Object params) {
            this.jsonrpc = jsonrpc;
            this.method = method;
            this.id = id;
            this.params = params;
        }

        @Override
        public String getJsonrpc() {
            return this.jsonrpc;
        }

        public String getMethod() {
            return this.method;
        }

        public Object getId() {
            return this.id;
        }

        public Object getParams() {
            return this.params;
        }
    }

    public static interface JSONRPCMessage {
        public String getJsonrpc();
    }

    public static interface Result
    extends Meta {
    }

    public static interface Request
    extends Meta {
        default public Object progressToken() {
            Map<String, Object> metadata = this.meta();
            if (metadata != null && metadata.containsKey("progressToken")) {
                return metadata.get("progressToken");
            }
            return null;
        }
    }

    public static interface Meta {
        default public Map<String, Object> meta() {
            return null;
        }
    }

    public static final class ErrorCodes {
        public static final int PARSE_ERROR = -32700;
        public static final int INVALID_REQUEST = -32600;
        public static final int METHOD_NOT_FOUND = -32601;
        public static final int INVALID_PARAMS = -32602;
        public static final int INTERNAL_ERROR = -32603;
    }
}

