/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.view;

import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.view.TableView;
import com.taobao.arthas.core.view.View;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class MethodInfoView
implements View {
    private final Method method;
    private final int width;

    public MethodInfoView(Method method, int width) {
        this.method = method;
        this.width = width;
    }

    @Override
    public String draw() {
        return new TableView(new TableView.ColumnDefine[]{new TableView.ColumnDefine("declaring-class".length(), false, TableView.Align.RIGHT), new TableView.ColumnDefine(this.width - "declaring-class".length() - 7, false, TableView.Align.LEFT)}).addRow("declaring-class", this.method.getDeclaringClass().getName()).addRow("method-name", this.method.getName()).addRow("modifier", StringUtils.modifier(this.method.getModifiers(), ',')).addRow("annotation", this.drawAnnotation()).addRow("parameters", this.drawParameters()).addRow("return", this.drawReturn()).addRow("exceptions", this.drawExceptions()).padding(1).hasBorder(true).draw();
    }

    private String drawAnnotation() {
        StringBuilder annotationSB = new StringBuilder();
        Annotation[] annotationArray = this.method.getDeclaredAnnotations();
        if (annotationArray.length > 0) {
            for (Annotation annotation : annotationArray) {
                annotationSB.append(StringUtils.classname(annotation.annotationType())).append(",");
            }
            if (annotationSB.length() > 0) {
                annotationSB.deleteCharAt(annotationSB.length() - 1);
            }
        } else {
            annotationSB.append("");
        }
        return annotationSB.toString();
    }

    private String drawParameters() {
        StringBuilder paramsSB = new StringBuilder();
        Class<?>[] paramTypes = this.method.getParameterTypes();
        if (paramTypes.length > 0) {
            for (Class<?> clazz : paramTypes) {
                paramsSB.append(StringUtils.classname(clazz)).append("\n");
            }
        }
        return paramsSB.toString();
    }

    private String drawReturn() {
        StringBuilder returnSB = new StringBuilder();
        Class<?> returnTypeClass = this.method.getReturnType();
        returnSB.append(StringUtils.classname(returnTypeClass)).append("\n");
        return returnSB.toString();
    }

    private String drawExceptions() {
        StringBuilder exceptionSB = new StringBuilder();
        Class<?>[] exceptionTypes = this.method.getExceptionTypes();
        if (exceptionTypes.length > 0) {
            for (Class<?> clazz : exceptionTypes) {
                exceptionSB.append(StringUtils.classname(clazz)).append("\n");
            }
        }
        return exceptionSB.toString();
    }
}

