/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.cli;

import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.OptionCompleteHandler;
import com.taobao.arthas.core.shell.term.Tty;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.usage.StyledUsageFormatter;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.Option;
import com.taobao.middleware.cli.annotations.CLIConfigurator;
import io.termd.core.util.Helper;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CompletionUtils {
    public static String findLongestCommonPrefix(Collection<String> values2) {
        LinkedList<int[]> entries = new LinkedList<int[]>();
        for (String value : values2) {
            int[] entry = Helper.toCodePoints(value);
            entries.add(entry);
        }
        return Helper.fromCodePoints(io.termd.core.readline.Completion.findLongestCommonPrefix(entries));
    }

    public static void complete(Completion completion, Class<?> clazz) {
        List<CliToken> tokens = completion.lineTokens();
        CliToken lastToken = tokens.get(tokens.size() - 1);
        CLI cli = CLIConfigurator.define(clazz);
        List<Option> options = cli.getOptions();
        if (lastToken == null || lastToken.isBlank()) {
            CompletionUtils.completeUsage(completion, cli);
        } else if (lastToken.value().startsWith("--")) {
            CompletionUtils.completeLongOption(completion, lastToken, options);
        } else if (lastToken.value().startsWith("-")) {
            CompletionUtils.completeShortOption(completion, lastToken, options);
        } else {
            completion.complete(Collections.emptyList());
        }
    }

    public static boolean complete(Completion completion, Collection<String> searchScope) {
        List<CliToken> tokens = completion.lineTokens();
        String lastToken = tokens.get(tokens.size() - 1).value();
        ArrayList<String> candidates = new ArrayList<String>();
        if (StringUtils.isBlank(lastToken)) {
            lastToken = "";
        }
        for (String name : searchScope) {
            if (!name.startsWith(lastToken)) continue;
            candidates.add(name);
        }
        if (candidates.size() == 1) {
            completion.complete(((String)candidates.get(0)).substring(lastToken.length()), true);
            return true;
        }
        completion.complete(candidates);
        return true;
    }

    private static boolean isEndOfDirectory(String token) {
        return !StringUtils.isBlank(token) && (token.endsWith(File.separator) || token.endsWith("/"));
    }

    public static boolean completeFilePath(Completion completion) {
        List<CliToken> tokens = completion.lineTokens();
        String token = tokens.get(tokens.size() - 1).value();
        if (token.startsWith("-") || StringUtils.isBlank(token)) {
            return false;
        }
        File dir = null;
        String partName = "";
        if (StringUtils.isBlank(token)) {
            dir = new File("").getAbsoluteFile();
            token = "";
        } else if (CompletionUtils.isEndOfDirectory(token)) {
            dir = new File(token);
        } else {
            File parent = new File(token).getAbsoluteFile().getParentFile();
            if (parent != null && parent.exists()) {
                dir = parent;
                partName = new File(token).getName();
            }
        }
        File tokenFile = new File(token);
        String tokenFileName = null;
        tokenFileName = CompletionUtils.isEndOfDirectory(token) ? "" : tokenFile.getName();
        if (dir == null) {
            return false;
        }
        File[] listFiles = dir.listFiles();
        ArrayList<String> names = new ArrayList<String>();
        if (listFiles != null) {
            for (File child : listFiles) {
                if (!child.getName().startsWith(partName)) continue;
                if (child.isDirectory()) {
                    names.add(child.getName() + "/");
                    continue;
                }
                names.add(child.getName());
            }
        }
        if (names.size() == 1 && CompletionUtils.isEndOfDirectory((String)names.get(0))) {
            String name = (String)names.get(0);
            completion.complete(name.substring(tokenFileName.length()), false);
            return true;
        }
        String prefix = null;
        prefix = CompletionUtils.isEndOfDirectory(token) ? token : token.substring(0, token.length() - new File(token).getName().length());
        ArrayList<String> namesWithPrefix = new ArrayList<String>();
        for (String name : names) {
            namesWithPrefix.add(prefix + name);
        }
        CompletionUtils.complete(completion, namesWithPrefix);
        return true;
    }

    public static boolean completeClassName(Completion completion) {
        List<CliToken> tokens = completion.lineTokens();
        String lastToken = tokens.get(tokens.size() - 1).value();
        if (StringUtils.isBlank(lastToken)) {
            lastToken = "";
        }
        if (lastToken.startsWith("-")) {
            return false;
        }
        Instrumentation instrumentation = completion.session().getInstrumentation();
        Class[] allLoadedClasses = instrumentation.getAllLoadedClasses();
        HashSet<String> result = new HashSet<String>();
        for (Class clazz : allLoadedClasses) {
            String name = clazz.getName();
            if (name.startsWith("[") || !name.startsWith(lastToken)) continue;
            int index = name.indexOf(46, lastToken.length());
            if (index > 0) {
                result.add(name.substring(0, index + 1));
                continue;
            }
            result.add(name);
        }
        if (result.size() == 1 && ((String)result.iterator().next()).endsWith(".")) {
            completion.complete(((String)result.iterator().next()).substring(lastToken.length()), false);
        } else {
            CompletionUtils.complete(completion, result);
        }
        return true;
    }

    public static boolean completeMethodName(Completion completion) {
        List<CliToken> tokens = completion.lineTokens();
        String lastToken = completion.lineTokens().get(tokens.size() - 1).value();
        if (StringUtils.isBlank(lastToken)) {
            lastToken = "";
        }
        String className = StringUtils.isBlank(lastToken) ? tokens.get(tokens.size() - 2).value() : tokens.get(tokens.size() - 3).value();
        Set<Class<?>> results = SearchUtils.searchClassOnly(completion.session().getInstrumentation(), className, 2);
        if (results.size() != 1) {
            completion.complete(Collections.emptyList());
            return true;
        }
        Class<?> clazz = results.iterator().next();
        ArrayList<String> res = new ArrayList<String>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (StringUtils.isBlank(lastToken)) {
                res.add(method.getName());
                continue;
            }
            if (!method.getName().startsWith(lastToken)) continue;
            res.add(method.getName());
        }
        res.add("<init>");
        if (res.size() == 1) {
            completion.complete(((String)res.get(0)).substring(lastToken.length()), true);
            return true;
        }
        CompletionUtils.complete(completion, res);
        return true;
    }

    public static int detectArgumentIndex(Completion completion) {
        List<CliToken> tokens = completion.lineTokens();
        CliToken lastToken = tokens.get(tokens.size() - 1);
        if (lastToken.value().startsWith("-") || lastToken.value().startsWith("--")) {
            return -1;
        }
        if (StringUtils.isBlank(lastToken.value()) && tokens.size() == 1) {
            return 1;
        }
        int tokenCount = 0;
        for (CliToken token : tokens) {
            if (StringUtils.isBlank(token.value()) || token.value().startsWith("-") || token.value().startsWith("--")) continue;
            ++tokenCount;
        }
        if (StringUtils.isBlank(lastToken.value()) && tokens.size() != 1) {
            ++tokenCount;
        }
        return tokenCount;
    }

    public static void completeShortOption(Completion completion, CliToken lastToken, List<Option> options) {
        String prefix = lastToken.value().substring(1);
        ArrayList<String> candidates = new ArrayList<String>();
        for (Option option : options) {
            if (!option.getShortName().startsWith(prefix)) continue;
            candidates.add(option.getShortName());
        }
        CompletionUtils.complete(completion, prefix, candidates);
    }

    public static void completeLongOption(Completion completion, CliToken lastToken, List<Option> options) {
        String prefix = lastToken.value().substring(2);
        ArrayList<String> candidates = new ArrayList<String>();
        for (Option option : options) {
            if (!option.getLongName().startsWith(prefix)) continue;
            candidates.add(option.getLongName());
        }
        CompletionUtils.complete(completion, prefix, candidates);
    }

    public static void completeUsage(Completion completion, CLI cli) {
        Tty tty = (Tty)completion.session().get("tty");
        String usage = StyledUsageFormatter.styledUsage(cli, tty.width());
        completion.complete(Collections.singletonList(usage));
    }

    private static void complete(Completion completion, String prefix, List<String> candidates) {
        if (candidates.size() == 1) {
            completion.complete(candidates.get(0).substring(prefix.length()), true);
        } else {
            String commonPrefix = CompletionUtils.findLongestCommonPrefix(candidates);
            if (commonPrefix.length() > 0) {
                if (commonPrefix.length() == prefix.length()) {
                    completion.complete(candidates);
                } else {
                    completion.complete(commonPrefix.substring(prefix.length()), false);
                }
            } else {
                completion.complete(candidates);
            }
        }
    }

    public static boolean shouldCompleteOption(Completion completion, String option) {
        CliToken cliToken_2;
        CliToken cliToken_1;
        List<CliToken> tokens = completion.lineTokens();
        if (tokens.size() >= 2) {
            cliToken_1 = tokens.get(tokens.size() - 1);
            cliToken_2 = tokens.get(tokens.size() - 2);
            String token_2 = cliToken_2.value();
            if (!cliToken_1.value().startsWith("-") && token_2.equals(option)) {
                return CompletionUtils.completeClassName(completion);
            }
        }
        if (tokens.size() >= 3) {
            cliToken_1 = tokens.get(tokens.size() - 1);
            cliToken_2 = tokens.get(tokens.size() - 2);
            CliToken cliToken_3 = tokens.get(tokens.size() - 3);
            if (!cliToken_1.value().startsWith("-") && cliToken_2.isBlank() && cliToken_3.value().equals(option)) {
                return CompletionUtils.completeClassName(completion);
            }
        }
        return false;
    }

    public static boolean completeOptions(Completion completion, List<OptionCompleteHandler> handlers) {
        List<CliToken> tokens = completion.lineTokens();
        if (tokens.size() >= 3) {
            CliToken cliToken_2 = tokens.get(tokens.size() - 2);
            CliToken cliToken_3 = tokens.get(tokens.size() - 3);
            if (cliToken_2.isBlank()) {
                String token_3 = cliToken_3.value();
                for (OptionCompleteHandler handler : handlers) {
                    if (!handler.matchName(token_3)) continue;
                    return handler.complete(completion);
                }
            }
        }
        if (tokens.size() >= 2) {
            CliToken cliToken_1 = tokens.get(tokens.size() - 1);
            CliToken cliToken_2 = tokens.get(tokens.size() - 2);
            if (cliToken_1.isBlank()) {
                String token_2 = cliToken_2.value();
                for (OptionCompleteHandler handler : handlers) {
                    if (!handler.matchName(token_2)) continue;
                    return handler.complete(completion);
                }
            }
        }
        return false;
    }
}

