/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.env;

import com.taobao.arthas.core.env.PropertySource;
import com.taobao.arthas.core.env.PropertySources;
import java.util.Iterator;
import java.util.LinkedList;

public class MutablePropertySources
implements PropertySources {
    static final String NON_EXISTENT_PROPERTY_SOURCE_MESSAGE = "PropertySource named [%s] does not exist";
    static final String ILLEGAL_RELATIVE_ADDITION_MESSAGE = "PropertySource named [%s] cannot be added relative to itself";
    private final LinkedList<PropertySource<?>> propertySourceList = new LinkedList();

    public MutablePropertySources() {
    }

    public MutablePropertySources(PropertySources propertySources) {
        this();
        for (PropertySource propertySource : propertySources) {
            this.addLast(propertySource);
        }
    }

    @Override
    public boolean contains(String name) {
        return this.propertySourceList.contains(PropertySource.named(name));
    }

    @Override
    public PropertySource<?> get(String name) {
        int index = this.propertySourceList.indexOf(PropertySource.named(name));
        return index == -1 ? null : this.propertySourceList.get(index);
    }

    @Override
    public Iterator<PropertySource<?>> iterator() {
        return this.propertySourceList.iterator();
    }

    public void addFirst(PropertySource<?> propertySource) {
        this.removeIfPresent(propertySource);
        this.propertySourceList.addFirst(propertySource);
    }

    public void addLast(PropertySource<?> propertySource) {
        this.removeIfPresent(propertySource);
        this.propertySourceList.addLast(propertySource);
    }

    public void addBefore(String relativePropertySourceName, PropertySource<?> propertySource) {
        this.assertLegalRelativeAddition(relativePropertySourceName, propertySource);
        this.removeIfPresent(propertySource);
        int index = this.assertPresentAndGetIndex(relativePropertySourceName);
        this.addAtIndex(index, propertySource);
    }

    public void addAfter(String relativePropertySourceName, PropertySource<?> propertySource) {
        this.assertLegalRelativeAddition(relativePropertySourceName, propertySource);
        this.removeIfPresent(propertySource);
        int index = this.assertPresentAndGetIndex(relativePropertySourceName);
        this.addAtIndex(index + 1, propertySource);
    }

    public int precedenceOf(PropertySource<?> propertySource) {
        return this.propertySourceList.indexOf(propertySource);
    }

    public PropertySource<?> remove(String name) {
        int index = this.propertySourceList.indexOf(PropertySource.named(name));
        return index == -1 ? null : this.propertySourceList.remove(index);
    }

    public void replace(String name, PropertySource<?> propertySource) {
        int index = this.assertPresentAndGetIndex(name);
        this.propertySourceList.set(index, propertySource);
    }

    public int size() {
        return this.propertySourceList.size();
    }

    public String toString() {
        Object[] names = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            names[i] = this.propertySourceList.get(i).getName();
        }
        return String.format("[%s]", MutablePropertySources.arrayToCommaDelimitedString(names));
    }

    protected void assertLegalRelativeAddition(String relativePropertySourceName, PropertySource<?> propertySource) {
    }

    protected void removeIfPresent(PropertySource<?> propertySource) {
        this.propertySourceList.remove(propertySource);
    }

    private void addAtIndex(int index, PropertySource<?> propertySource) {
        this.removeIfPresent(propertySource);
        this.propertySourceList.add(index, propertySource);
    }

    private int assertPresentAndGetIndex(String name) {
        int index = this.propertySourceList.indexOf(PropertySource.named(name));
        return index;
    }

    private static String arrayToDelimitedString(Object[] arr, String delim) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        if (arr.length == 1) {
            return MutablePropertySources.nullSafeToString(arr[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    private static String nullSafeToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Object[]) {
            return MutablePropertySources.nullSafeToString((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return MutablePropertySources.nullSafeToString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return MutablePropertySources.nullSafeToString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return MutablePropertySources.nullSafeToString((char[])obj);
        }
        if (obj instanceof double[]) {
            return MutablePropertySources.nullSafeToString((double[])obj);
        }
        if (obj instanceof float[]) {
            return MutablePropertySources.nullSafeToString((float[])obj);
        }
        if (obj instanceof int[]) {
            return MutablePropertySources.nullSafeToString((int[])obj);
        }
        if (obj instanceof long[]) {
            return MutablePropertySources.nullSafeToString((long[])obj);
        }
        if (obj instanceof short[]) {
            return MutablePropertySources.nullSafeToString((short[])obj);
        }
        String str = obj.toString();
        return str != null ? str : "";
    }

    private static String arrayToCommaDelimitedString(Object[] arr) {
        return MutablePropertySources.arrayToDelimitedString(arr, ",");
    }
}

