/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathCompilerReflect;
import com.alibaba.fastjson2.JSONPathSingleName;
import com.alibaba.fastjson2.internal.asm.ASMUtils;
import com.alibaba.fastjson2.internal.asm.ClassWriter;
import com.alibaba.fastjson2.internal.asm.MethodWriter;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.DynamicClassLoader;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicLong;

final class JSONPathCompilerReflectASM
extends JSONPathCompilerReflect {
    private static final AtomicLong seed = new AtomicLong();
    static final JSONPathCompilerReflectASM INSTANCE = new JSONPathCompilerReflectASM(DynamicClassLoader.getInstance());
    private static final String TYPE_SINGLE_NAME_PATH_TYPED = ASMUtils.type(JSONPathCompilerReflect.SingleNamePathTyped.class);
    private static final String METHOD_SINGLE_NAME_PATH_TYPED_INIT = "(Ljava/lang/String;Ljava/lang/Class;" + ASMUtils.DESC_OBJECT_READER + ASMUtils.DESC_FIELD_READER + ASMUtils.DESC_OBJECT_WRITER + ASMUtils.DESC_FIELD_WRITER + ")V";
    private final DynamicClassLoader classLoader;

    public JSONPathCompilerReflectASM(DynamicClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private boolean support(Class objectClass) {
        boolean externalClass = this.classLoader.isExternalClass(objectClass);
        int objectClassModifiers = objectClass.getModifiers();
        return Modifier.isAbstract(objectClassModifiers) || Modifier.isInterface(objectClassModifiers) || !Modifier.isPublic(objectClassModifiers) || externalClass;
    }

    @Override
    protected JSONPath compileSingleNamePath(Class objectClass, JSONPathSingleName path) {
        int OBJECT;
        String classNameType;
        String classNameFull;
        if (this.support(objectClass)) {
            return super.compileSingleNamePath(objectClass, path);
        }
        String fieldName = path.name;
        String TYPE_OBJECT = ASMUtils.type(objectClass);
        ObjectReader objectReader = path.getReaderContext().getObjectReader(objectClass);
        FieldReader fieldReader = objectReader.getFieldReader(fieldName);
        ObjectWriter objectWriter = path.getWriterContext().getObjectWriter(objectClass);
        FieldWriter fieldWriter = objectWriter.getFieldWriter(fieldName);
        ClassWriter cw = new ClassWriter(null);
        String className = "JSONPath_" + seed.incrementAndGet();
        Package pkg = JSONPathCompilerReflectASM.class.getPackage();
        if (pkg != null) {
            String packageName = pkg.getName();
            int packageNameLength = packageName.length();
            int charsLength = packageNameLength + 1 + className.length();
            char[] chars = new char[charsLength];
            packageName.getChars(0, packageName.length(), chars, 0);
            chars[packageNameLength] = 46;
            className.getChars(0, className.length(), chars, packageNameLength + 1);
            classNameFull = new String(chars);
            chars[packageNameLength] = 47;
            for (int i = 0; i < packageNameLength; ++i) {
                if (chars[i] != '.') continue;
                chars[i] = 47;
            }
            classNameType = new String(chars);
        } else {
            classNameType = className;
            classNameFull = className;
        }
        cw.visit(52, 49, classNameType, TYPE_SINGLE_NAME_PATH_TYPED, new String[0]);
        boolean THIS = false;
        boolean PATH = true;
        int CLASS = 2;
        int OBJECT_READER = 3;
        int FIELD_READER = 4;
        int OBJECT_WRITER = 5;
        int FIELD_WRITER = 6;
        MethodWriter mw = cw.visitMethod(1, "<init>", METHOD_SINGLE_NAME_PATH_TYPED_INIT, 64);
        mw.aload(0);
        mw.aload(1);
        mw.aload(2);
        mw.aload(3);
        mw.aload(4);
        mw.aload(5);
        mw.aload(6);
        mw.invokespecial(TYPE_SINGLE_NAME_PATH_TYPED, "<init>", METHOD_SINGLE_NAME_PATH_TYPED_INIT);
        mw.return_();
        mw.visitMaxs(3, 3);
        if (fieldReader != null) {
            Class fieldClass = fieldReader.fieldClass;
            OBJECT = 1;
            int VALUE = 2;
            if (fieldClass == Integer.TYPE) {
                MethodWriter mw2 = cw.visitMethod(1, "setInt", "(Ljava/lang/Object;I)V", 64);
                mw2.aload(OBJECT);
                mw2.checkcast(TYPE_OBJECT);
                mw2.visitVarInsn(21, VALUE);
                this.gwSetValue(mw2, TYPE_OBJECT, fieldReader);
                mw2.return_();
                mw2.visitMaxs(2, 2);
            }
            if (fieldClass == Long.TYPE) {
                MethodWriter mw3 = cw.visitMethod(1, "setLong", "(Ljava/lang/Object;J)V", 64);
                mw3.aload(OBJECT);
                mw3.checkcast(TYPE_OBJECT);
                mw3.lload(VALUE);
                this.gwSetValue(mw3, TYPE_OBJECT, fieldReader);
                mw3.return_();
                mw3.visitMaxs(2, 2);
            }
            MethodWriter mw4 = cw.visitMethod(1, "set", "(Ljava/lang/Object;Ljava/lang/Object;)V", 64);
            mw4.aload(OBJECT);
            mw4.checkcast(TYPE_OBJECT);
            mw4.aload(VALUE);
            if (fieldClass == Integer.TYPE) {
                mw4.checkcast("java/lang/Number");
                mw4.invokevirtual("java/lang/Number", "intValue", "()I");
            } else if (fieldClass == Long.TYPE) {
                mw4.checkcast("java/lang/Number");
                mw4.invokevirtual("java/lang/Number", "longValue", "()J");
            } else if (fieldClass == Float.TYPE) {
                mw4.checkcast("java/lang/Number");
                mw4.invokevirtual("java/lang/Number", "floatValue", "()F");
            } else if (fieldClass == Double.TYPE) {
                mw4.checkcast("java/lang/Number");
                mw4.invokevirtual("java/lang/Number", "doubleValue", "()D");
            } else if (fieldClass == Short.TYPE) {
                mw4.checkcast("java/lang/Number");
                mw4.invokevirtual("java/lang/Number", "shortValue", "()S");
            } else if (fieldClass == Byte.TYPE) {
                mw4.checkcast("java/lang/Number");
                mw4.invokevirtual("java/lang/Number", "byteValue", "()B");
            } else if (fieldClass == Boolean.TYPE) {
                mw4.checkcast("java/lang/Boolean");
                mw4.invokevirtual("java/lang/Boolean", "booleanValue", "()Z");
            } else if (fieldClass == Character.TYPE) {
                mw4.checkcast("java/lang/Character");
                mw4.invokevirtual("java/lang/Character", "charValue", "()C");
            }
            this.gwSetValue(mw4, TYPE_OBJECT, fieldReader);
            mw4.return_();
            mw4.visitMaxs(2, 2);
        }
        if (fieldWriter != null) {
            Class fieldClass = fieldReader.fieldClass;
            OBJECT = 1;
            MethodWriter mw5 = cw.visitMethod(1, "eval", "(Ljava/lang/Object;)Ljava/lang/Object;", 64);
            mw5.aload(OBJECT);
            mw5.checkcast(TYPE_OBJECT);
            this.gwGetValue(mw5, TYPE_OBJECT, fieldWriter);
            if (fieldClass == Integer.TYPE) {
                mw5.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            } else if (fieldClass == Long.TYPE) {
                mw5.invokestatic("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            } else if (fieldClass == Float.TYPE) {
                mw5.invokestatic("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
            } else if (fieldClass == Double.TYPE) {
                mw5.invokestatic("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            } else if (fieldClass == Short.TYPE) {
                mw5.invokestatic("java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
            } else if (fieldClass == Byte.TYPE) {
                mw5.invokestatic("java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
            } else if (fieldClass == Boolean.TYPE) {
                mw5.invokestatic("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
            } else if (fieldClass == Character.TYPE) {
                mw5.invokestatic("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
            }
            mw5.areturn();
            mw5.visitMaxs(2, 2);
        }
        byte[] code = cw.toByteArray();
        Class<?> readerClass = this.classLoader.defineClassPublic(classNameFull, code, 0, code.length);
        try {
            Constructor<?> constructor = readerClass.getConstructors()[0];
            return (JSONPath)constructor.newInstance(path.path, objectClass, objectReader, fieldReader, objectWriter, fieldWriter);
        }
        catch (Throwable e) {
            throw new JSONException("compile jsonpath error, path " + path.path + ", objectType " + objectClass.getTypeName(), e);
        }
    }

    private void gwSetValue(MethodWriter mw, String TYPE_OBJECT, FieldReader fieldReader) {
        Method method = fieldReader.method;
        Field field = fieldReader.field;
        Class fieldClass = fieldReader.fieldClass;
        String fieldClassDesc = ASMUtils.desc(fieldClass);
        if (method != null) {
            Class<?> returnType = method.getReturnType();
            String methodDesc = '(' + fieldClassDesc + ')' + ASMUtils.desc(returnType);
            mw.invokevirtual(TYPE_OBJECT, method.getName(), methodDesc);
            if (returnType != Void.TYPE) {
                mw.pop();
            }
        } else {
            mw.putfield(TYPE_OBJECT, field.getName(), fieldClassDesc);
        }
    }

    private void gwGetValue(MethodWriter mw, String TYPE_OBJECT, FieldWriter fieldWriter) {
        Method method = fieldWriter.method;
        Field field = fieldWriter.field;
        Class fieldClass = fieldWriter.fieldClass;
        String fieldClassDesc = ASMUtils.desc(fieldClass);
        if (method != null) {
            String methodDesc = "()" + fieldClassDesc;
            mw.invokevirtual(TYPE_OBJECT, method.getName(), methodDesc);
        } else {
            mw.getfield(TYPE_OBJECT, field.getName(), fieldClassDesc);
        }
    }
}

