/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.utils;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicReference;

public class BytecodeRetrievalTool {
    public static byte[] getClassBytecode(Instrumentation instrumentation, final Class<?> clazz) {
        final AtomicReference bytecodeRef = new AtomicReference();
        ClassFileTransformer transformer = new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain domain, byte[] classfileBuffer) throws IllegalClassFormatException {
                if (classBeingRedefined != null && clazz != classBeingRedefined) {
                    return null;
                }
                if (clazz.getName().replace('.', '/').equals(className)) {
                    bytecodeRef.set(classfileBuffer);
                    return null;
                }
                return null;
            }
        };
        instrumentation.addTransformer(transformer, true);
        try {
            instrumentation.retransformClasses(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Retransformation failed", e);
        }
        finally {
            instrumentation.removeTransformer(transformer);
        }
        return (byte[])bytecodeRef.get();
    }
}

