/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.matcher;

import com.alibaba.bytekit.asm.matcher.ClassMatcher;
import com.alibaba.bytekit.asm.meta.ClassMetaService;
import com.alibaba.bytekit.utils.AsmUtils;
import com.alibaba.bytekit.utils.ClassLoaderUtils;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SimpleInterfaceMatcher
implements ClassMatcher {
    private Set<String> interfaces = new HashSet<String>();
    private Set<String> internalInterfaces = new HashSet<String>();

    public SimpleInterfaceMatcher(String ... interfaces) {
        for (String name : interfaces) {
            this.add(name);
        }
    }

    public SimpleInterfaceMatcher(Collection<String> interfaces) {
        for (String name : interfaces) {
            this.add(name);
        }
    }

    private void add(String name) {
        this.interfaces.add(name);
        this.internalInterfaces.add(AsmUtils.internalClassName(name));
    }

    @Override
    public boolean match(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        loader = ClassLoaderUtils.wrap(loader);
        if (classBeingRedefined != null) {
            return this.match(classBeingRedefined);
        }
        Set<String> allInterfaces = ClassMetaService.allInterfaces(loader, className, classfileBuffer);
        for (String i : this.internalInterfaces) {
            if (!allInterfaces.contains(i)) continue;
            return true;
        }
        return false;
    }

    private boolean matchInterface(Class<?> i) {
        if (this.interfaces != null && this.interfaces.contains(i.getName())) {
            return true;
        }
        for (Class<?> iter : i.getInterfaces()) {
            if (!this.matchInterface(iter)) continue;
            return true;
        }
        return false;
    }

    private boolean matchClass(Class<?> clazz) {
        for (Class<?> i : clazz.getInterfaces()) {
            if (!this.matchInterface(i)) continue;
            return true;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (Object.class.equals(superclass)) {
            return false;
        }
        return this.matchClass(superclass);
    }

    private boolean match(Class<?> clazz) {
        if (clazz.isInterface()) {
            return this.matchInterface(clazz);
        }
        return this.matchClass(clazz);
    }
}

