/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.monitor;

import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.StringMonitor;

public class MonitoredVmUtil {
    private static int IS_ATTACHABLE = 0;
    private static int IS_KERNEL_VM = 1;

    private MonitoredVmUtil() {
    }

    public static String vmVersion(MonitoredVm vm) throws MonitorException {
        StringMonitor ver = (StringMonitor)vm.findByName("java.property.java.vm.version");
        return ver == null ? "Unknown" : ver.stringValue();
    }

    public static String commandLine(MonitoredVm vm) throws MonitorException {
        StringMonitor cmd = (StringMonitor)vm.findByName("sun.rt.javaCommand");
        return cmd == null ? "Unknown" : cmd.stringValue();
    }

    public static String mainArgs(MonitoredVm vm) throws MonitorException {
        String commandLine = MonitoredVmUtil.commandLine(vm);
        int firstSpace = commandLine.indexOf(32);
        if (firstSpace > 0) {
            return commandLine.substring(firstSpace + 1);
        }
        if (commandLine.compareTo("Unknown") == 0) {
            return commandLine;
        }
        return null;
    }

    public static String mainClass(MonitoredVm vm, boolean fullPath) throws MonitorException {
        String commandLine;
        String arg0 = commandLine = MonitoredVmUtil.commandLine(vm);
        int firstSpace = commandLine.indexOf(32);
        if (firstSpace > 0) {
            arg0 = commandLine.substring(0, firstSpace);
        }
        if (!fullPath) {
            int lastFileSeparator = arg0.lastIndexOf(47);
            if (lastFileSeparator > 0) {
                return arg0.substring(lastFileSeparator + 1);
            }
            lastFileSeparator = arg0.lastIndexOf(92);
            if (lastFileSeparator > 0) {
                return arg0.substring(lastFileSeparator + 1);
            }
            int lastPackageSeparator = arg0.lastIndexOf(46);
            if (lastPackageSeparator > 0) {
                return arg0.substring(lastPackageSeparator + 1);
            }
        }
        return arg0;
    }

    public static String jvmArgs(MonitoredVm vm) throws MonitorException {
        StringMonitor jvmArgs = (StringMonitor)vm.findByName("java.rt.vmArgs");
        return jvmArgs == null ? "Unknown" : jvmArgs.stringValue();
    }

    public static String jvmFlags(MonitoredVm vm) throws MonitorException {
        StringMonitor jvmFlags = (StringMonitor)vm.findByName("java.rt.vmFlags");
        return jvmFlags == null ? "Unknown" : jvmFlags.stringValue();
    }

    public static boolean isAttachable(MonitoredVm vm) throws MonitorException {
        StringMonitor jvmCapabilities = (StringMonitor)vm.findByName("sun.rt.jvmCapabilities");
        if (jvmCapabilities == null) {
            return false;
        }
        return jvmCapabilities.stringValue().charAt(IS_ATTACHABLE) == '1';
    }
}

