/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.util;

import io.termd.core.function.Consumer;
import io.termd.core.function.IntConsumer;
import io.termd.core.util.CompletableFuture;
import io.termd.core.util.Vector;
import io.termd.core.util.Wcwidth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class Helper {
    public static void uncheckedThrow(Throwable throwable) {
        Helper.throwIt(throwable);
    }

    private static <T extends Throwable> void throwIt(Throwable throwable) throws T {
        throw throwable;
    }

    public static void noop() {
    }

    public static int[] toCodePoints(String s2) {
        int cp;
        ArrayList<Integer> codePoints = new ArrayList<Integer>();
        for (int offset = 0; offset < s2.length(); offset += Character.charCount(cp)) {
            cp = s2.codePointAt(offset);
            codePoints.add(cp);
        }
        return Helper.convert(codePoints);
    }

    public static String fromCodePoints(int[] codePoints) {
        return new String(codePoints, 0, codePoints.length);
    }

    public static void appendCodePoints(int[] codePoints, final StringBuilder sb) {
        Helper.consumeTo(codePoints, new IntConsumer(){

            @Override
            public void accept(int cp) {
                sb.appendCodePoint(cp);
            }
        });
    }

    public static void consumeTo(int[] i, IntConsumer consumer) {
        for (int codePoint : i) {
            consumer.accept(codePoint);
        }
    }

    public static <S> List<S> loadServices(ClassLoader loader, Class<S> serviceClass) {
        ArrayList<S> services = new ArrayList<S>();
        Iterator<S> i = ServiceLoader.load(serviceClass, loader).iterator();
        while (i.hasNext()) {
            try {
                S service = i.next();
                services.add(service);
            }
            catch (Exception exception) {}
        }
        return services;
    }

    public static List<Integer> list(int ... list) {
        ArrayList<Integer> result = new ArrayList<Integer>(list.length);
        for (int i : list) {
            result.add(i);
        }
        return result;
    }

    public static List<String> split(String s2, char c) {
        int pos;
        ArrayList<String> ret = new ArrayList<String>();
        int prev = 0;
        while ((pos = s2.indexOf(10, prev)) != -1) {
            ret.add(s2.substring(prev, pos));
            prev = pos + 1;
        }
        ret.add(s2.substring(prev));
        return ret;
    }

    public static String escape(String s2) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == '\u0000') {
                sb.append("\\0");
                continue;
            }
            if (c < ' ') {
                sb.append("\\");
                String octal = Integer.toOctalString(c);
                for (int j = octal.length(); j < 3; ++j) {
                    sb.append('0');
                }
                sb.append(octal);
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static int[] findLongestCommonPrefix(List<int[]> entries) {
        int len;
        if (entries.isEmpty()) {
            return new int[0];
        }
        int minLen = Helper.min(entries);
        block0: for (len = 0; len < minLen; ++len) {
            for (int j = 1; j < entries.size(); ++j) {
                if (entries.get(j)[len] != entries.get(j - 1)[len]) break block0;
            }
        }
        return Arrays.copyOf(entries.get(0), len);
    }

    public static int[] computeBlock(Vector size, List<int[]> completions) {
        if (completions.size() == 0) {
            return new int[0];
        }
        int max = Helper.max(completions);
        int row = size.x() / (max + 1);
        int count = 0;
        StringBuilder sb = new StringBuilder();
        for (int[] completion : completions) {
            Helper.appendCodePoints(completion, sb);
            for (int i = completion.length; i < max; ++i) {
                sb.append(' ');
            }
            if (++count < row) {
                sb.append(' ');
                continue;
            }
            sb.append('\n');
            count = 0;
        }
        sb.append("\n");
        return Helper.toCodePoints(sb.toString());
    }

    public static Vector computePosition(int[] codePoints, Vector origin, int offset, int width) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Offset cannot be negative");
        }
        if (offset > codePoints.length) {
            throw new IndexOutOfBoundsException("Offset cannot bebe greater than the length");
        }
        int col = origin.x();
        int row = origin.y();
        for (int i = 0; i < offset; ++i) {
            int cp = codePoints[i];
            int w = Wcwidth.of(cp);
            if (w == -1) {
                if (cp == 13) {
                    col = 0;
                    continue;
                }
                if (cp != 10) continue;
                col = 0;
                ++row;
                continue;
            }
            if (col + w > width) {
                if (w > width) {
                    throw new UnsupportedOperationException("Handle this case gracefully");
                }
                col = 0;
                ++row;
            }
            if ((col += w) < width) continue;
            col -= width;
            ++row;
        }
        return new Vector(col, row);
    }

    public static Consumer<Throwable> startedHandler(final CompletableFuture<?> fut) {
        return new Consumer<Throwable>(){

            @Override
            public void accept(Throwable err) {
                if (err == null) {
                    fut.complete(null);
                } else {
                    fut.completeExceptionally(err);
                }
            }
        };
    }

    public static Consumer<Throwable> stoppedHandler(final CompletableFuture<?> fut) {
        return new Consumer<Throwable>(){

            @Override
            public void accept(Throwable err) {
                fut.complete(null);
            }
        };
    }

    public static int[] convert(List<Integer> ints) {
        int[] result = new int[ints.size()];
        for (int index = 0; index < ints.size(); ++index) {
            result[index] = ints.get(index);
        }
        return result;
    }

    private static int min(List<int[]> entries) {
        int minLen = entries.get(0).length;
        for (int i = 1; i < entries.size(); ++i) {
            int len = entries.get(i).length;
            if (minLen <= len) continue;
            minLen = len;
        }
        return minLen;
    }

    private static int max(List<int[]> entries) {
        int maxLen = entries.get(0).length;
        for (int i = 1; i < entries.size(); ++i) {
            int len = entries.get(i).length;
            if (maxLen >= len) continue;
            maxLen = len;
        }
        return maxLen;
    }
}

