/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.readline.functions;

import io.termd.core.readline.Function;
import io.termd.core.readline.LineBuffer;
import io.termd.core.readline.Readline;
import io.termd.core.util.LineBufferUtils;
import java.util.List;

public class HistorySearchBackward
implements Function {
    @Override
    public String name() {
        return "history-search-backward";
    }

    @Override
    public void apply(Readline.Interaction interaction) {
        block4: {
            int searchStart;
            List<int[]> history;
            int cursor;
            LineBuffer buf;
            block3: {
                int next;
                buf = interaction.buffer().copy();
                cursor = buf.getCursor();
                history = interaction.history();
                int curr = interaction.getHistoryIndex();
                boolean applyNext = false;
                if (buf.getSize() == 0) {
                    applyNext = true;
                }
                if (cursor == buf.getSize() && curr >= 0 && LineBufferUtils.equals(buf, history.get(curr)) && (next = curr + 1) < history.size()) {
                    applyNext = true;
                }
                if (!applyNext) break block3;
                next = curr + 1;
                if (next >= history.size()) break block4;
                int[] nextHistory = history.get(next);
                interaction.refresh(new LineBuffer().insert(nextHistory));
                interaction.setHistoryIndex(next);
                break block4;
            }
            for (int i = searchStart = curr + 1; i < history.size(); ++i) {
                int[] line = history.get(i);
                if (LineBufferUtils.equals(buf, line) || !LineBufferUtils.matchBeforeCursor(buf, line)) continue;
                interaction.refresh(new LineBuffer().insert(line).setCursor(cursor));
                interaction.setHistoryIndex(i);
                break;
            }
        }
        interaction.resume();
    }
}

