/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.ui;

import com.taobao.text.LineRenderer;
import com.taobao.text.Style;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelLineRenderer;
import com.taobao.text.util.CharSlicer;
import com.taobao.text.util.Pair;
import com.taobao.text.util.Utils;

public class LabelElement
extends Element {
    final String value;
    final int minWidth;
    final int actualWidth;
    final int actualHeight;
    final CharSlicer slicer;

    public LabelElement(Object value, int minWidth) throws IllegalArgumentException {
        if (minWidth < 0) {
            throw new IllegalArgumentException("No negative min size allowed");
        }
        String s2 = String.valueOf(value);
        s2 = Utils.replace(s2, "\\r\\n", "\n");
        s2 = Utils.replace(s2, "\\r", "\n");
        CharSlicer slicer = new CharSlicer(s2);
        Pair<Integer, Integer> size = slicer.size();
        this.value = s2;
        this.minWidth = Math.min(size.getFirst(), minWidth);
        this.actualWidth = size.getFirst();
        this.actualHeight = size.getSecond();
        this.slicer = slicer;
    }

    public LabelElement(String value) {
        this((Object)value);
    }

    public LabelElement(String value, int minWidth) {
        this((Object)value, minWidth);
    }

    public LabelElement(Object value) {
        this(value, 1);
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public LineRenderer renderer() {
        return new LabelLineRenderer(this);
    }

    public String toString() {
        return "Label[" + this.value + "]";
    }

    @Override
    public LabelElement style(Style.Composite style) {
        return (LabelElement)super.style(style);
    }
}

