/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.ui;

import com.taobao.text.LineReader;
import com.taobao.text.LineRenderer;
import com.taobao.text.RenderAppendable;
import com.taobao.text.Style;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.RowElement;

public abstract class Element {
    private Style.Composite style = null;

    protected Element() {
    }

    public abstract LineRenderer renderer();

    public void render(RenderAppendable to) {
        LineRenderer renderer = this.renderer();
        LineReader reader = renderer.reader(to.getWidth(), to.getHeight() - 1);
        if (reader != null) {
            while (reader.hasLine()) {
                reader.renderLine(to);
                to.append('\n');
            }
        }
    }

    public final Style.Composite getStyle() {
        return this.style;
    }

    public final void setStyle(Style.Composite style) {
        this.style = style;
    }

    public Element style(Style.Composite style) {
        this.setStyle(style);
        return this;
    }

    public static RowElement row() {
        return new RowElement();
    }

    public static RowElement header() {
        return new RowElement(true);
    }

    public static LabelElement label(String value) {
        return new LabelElement(value);
    }
}

