/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.renderers;

import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.LineRenderer;
import com.taobao.text.Renderer;
import com.taobao.text.ui.Overflow;
import com.taobao.text.ui.RowElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.Utils;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ObjectNameRenderer
extends Renderer<ObjectName> {
    @Override
    public Class<ObjectName> getType() {
        return ObjectName.class;
    }

    @Override
    public LineRenderer renderer(Iterator<ObjectName> stream) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        List<ObjectName> names = Utils.list(stream);
        Collections.sort(names);
        TableElement table = new TableElement().overflow(Overflow.HIDDEN).rightCellPadding(1);
        table.add(new RowElement().style(Decoration.bold.fg(Color.black).bg(Color.white)).add("NAME", "CLASSNAME", "MXBEAN", "DESCRIPTION"));
        for (ObjectName name : names) {
            String mxbean;
            String description;
            String className;
            try {
                MBeanInfo info = server.getMBeanInfo(name);
                className = info.getClassName();
                description = info.getDescription();
                Object mxbeanValue = info.getDescriptor().getFieldValue("mxbean");
                mxbean = mxbeanValue != null ? mxbeanValue.toString() : "false";
            }
            catch (JMException ignore) {
                className = "";
                description = "";
                mxbean = "";
            }
            table.row("" + name, className, mxbean, description);
        }
        return table.renderer();
    }
}

