/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.tool.function.jvm300;

import com.taobao.arthas.mcp.server.tool.ToolContext;
import com.taobao.arthas.mcp.server.tool.annotation.Tool;
import com.taobao.arthas.mcp.server.tool.annotation.ToolParam;
import com.taobao.arthas.mcp.server.tool.function.AbstractArthasTool;

public class MBeanTool
extends AbstractArthasTool {
    public static final int DEFAULT_NUMBER_OF_EXECUTIONS = 3;
    public static final int DEFAULT_REFRESH_INTERVAL_MS = 3000;

    @Tool(name="mbean", description="MBean \u8bca\u65ad\u5de5\u5177: \u67e5\u770b\u6216\u76d1\u63a7 MBean \u5c5e\u6027\u4fe1\u606f\uff0c\u5bf9\u5e94 Arthas \u7684 mbean \u547d\u4ee4\u3002")
    public String mbean(@ToolParam(description="MBean\u540d\u79f0\u8868\u8fbe\u5f0f\u5339\u914d\uff0c\u5982java.lang:type=GarbageCollector,name=*") String namePattern, @ToolParam(description="\u5c5e\u6027\u540d\u8868\u8fbe\u5f0f\u5339\u914d\uff0c\u652f\u6301\u901a\u914d\u7b26\u5982CollectionCount", required=false) String attributePattern, @ToolParam(description="\u662f\u5426\u67e5\u770b\u5143\u4fe1\u606f (-m)", required=false) Boolean metadata, @ToolParam(description="\u5237\u65b0\u95f4\u9694\uff0c\u5355\u4f4d\u4e3a\u6beb\u79d2\uff0c\u9ed8\u8ba4 3000ms\u3002\u7528\u4e8e\u63a7\u5236\u8f93\u51fa\u9891\u7387", required=false) Integer intervalMs, @ToolParam(description="\u6267\u884c\u6b21\u6570\u9650\u5236\uff0c\u9ed8\u8ba4\u503c\u4e3a 3\u3002\u8fbe\u5230\u6307\u5b9a\u6b21\u6570\u540e\u81ea\u52a8\u505c\u6b62", required=false) Integer numberOfExecutions, @ToolParam(description="\u5f00\u542f\u6b63\u5219\u8868\u8fbe\u5f0f\u5339\u914d\uff0c\u9ed8\u8ba4\u4e3a\u901a\u914d\u7b26\u5339\u914d\uff0c\u9ed8\u8ba4false", required=false) Boolean regex, ToolContext toolContext) {
        boolean needStreamOutput = intervalMs != null && intervalMs > 0 || numberOfExecutions != null && numberOfExecutions > 0;
        int interval = this.getDefaultValue(intervalMs, 3000);
        int execCount = this.getDefaultValue(numberOfExecutions, 3);
        StringBuilder cmd = this.buildCommand("mbean");
        this.addFlag(cmd, "-m", metadata);
        this.addFlag(cmd, "-E", regex);
        if (needStreamOutput && !Boolean.TRUE.equals(metadata)) {
            cmd.append(" -i ").append(interval);
            cmd.append(" -n ").append(execCount);
        }
        if (namePattern != null && !namePattern.trim().isEmpty()) {
            cmd.append(" ").append(namePattern.trim());
        }
        if (attributePattern != null && !attributePattern.trim().isEmpty()) {
            cmd.append(" ").append(attributePattern.trim());
        }
        this.logger.info("Starting mbean execution: {}", (Object)cmd.toString());
        return this.executeSync(toolContext, cmd.toString());
    }
}

