/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.taobao.arthas.mcp.server.CommandExecutor;
import com.taobao.arthas.mcp.server.protocol.config.McpServerProperties;
import com.taobao.arthas.mcp.server.protocol.server.McpNettyServer;
import com.taobao.arthas.mcp.server.protocol.server.McpServer;
import com.taobao.arthas.mcp.server.protocol.server.McpStatelessNettyServer;
import com.taobao.arthas.mcp.server.protocol.server.handler.McpHttpRequestHandler;
import com.taobao.arthas.mcp.server.protocol.server.handler.McpStatelessHttpRequestHandler;
import com.taobao.arthas.mcp.server.protocol.server.handler.McpStreamableHttpRequestHandler;
import com.taobao.arthas.mcp.server.protocol.server.transport.NettyStatelessServerTransport;
import com.taobao.arthas.mcp.server.protocol.server.transport.NettyStreamableServerTransportProvider;
import com.taobao.arthas.mcp.server.protocol.spec.McpSchema;
import com.taobao.arthas.mcp.server.tool.DefaultToolCallbackProvider;
import com.taobao.arthas.mcp.server.tool.ToolCallback;
import com.taobao.arthas.mcp.server.tool.util.McpToolUtils;
import com.taobao.arthas.mcp.server.util.JsonParser;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArthasMcpServer {
    private static final Logger logger = LoggerFactory.getLogger(ArthasMcpServer.class);
    private McpNettyServer streamableServer;
    private McpStatelessNettyServer statelessServer;
    private final String mcpEndpoint;
    private final CommandExecutor commandExecutor;
    private McpHttpRequestHandler unifiedMcpHandler;
    private McpStreamableHttpRequestHandler streamableHandler;
    private McpStatelessHttpRequestHandler statelessHandler;
    public static final String DEFAULT_MCP_ENDPOINT = "/mcp";

    public ArthasMcpServer(String mcpEndpoint, CommandExecutor commandExecutor) {
        this.mcpEndpoint = mcpEndpoint != null ? mcpEndpoint : DEFAULT_MCP_ENDPOINT;
        this.commandExecutor = commandExecutor;
    }

    public McpHttpRequestHandler getMcpRequestHandler() {
        return this.unifiedMcpHandler;
    }

    public void start() {
        try {
            McpServerProperties properties = new McpServerProperties.Builder().name("arthas-mcp-server").version("1.0.0").mcpEndpoint(this.mcpEndpoint).toolChangeNotification(true).resourceChangeNotification(true).promptChangeNotification(true).objectMapper(JsonParser.getObjectMapper()).build();
            DefaultToolCallbackProvider toolCallbackProvider = new DefaultToolCallbackProvider();
            ToolCallback[] callbacks = toolCallbackProvider.getToolCallbacks();
            List<ToolCallback> providerToolCallbacks = Arrays.stream(callbacks).filter(Objects::nonNull).collect(Collectors.toList());
            NettyStreamableServerTransportProvider transportProvider = this.createStreamableHttpTransportProvider(properties);
            this.streamableHandler = transportProvider.getMcpRequestHandler();
            NettyStatelessServerTransport statelessTransport = this.createStatelessHttpTransport(properties);
            this.statelessHandler = statelessTransport.getMcpRequestHandler();
            this.unifiedMcpHandler = McpHttpRequestHandler.builder().mcpEndpoint(properties.getMcpEndpoint()).objectMapper(properties.getObjectMapper()).tools(Arrays.asList(callbacks)).build();
            this.unifiedMcpHandler.setStreamableHandler(this.streamableHandler);
            this.unifiedMcpHandler.setStatelessHandler(this.statelessHandler);
            McpServer.StreamableServerNettySpecification streamableServerNettySpecification = McpServer.netty(transportProvider).serverInfo(new McpSchema.Implementation(properties.getName(), properties.getVersion())).capabilities(this.buildServerCapabilities(properties)).instructions(properties.getInstructions()).requestTimeout(properties.getRequestTimeout()).commandExecutor(this.commandExecutor).objectMapper(properties.getObjectMapper() != null ? properties.getObjectMapper() : JsonParser.getObjectMapper());
            McpServer.StatelessServerNettySpecification statelessServerNettySpecification = McpServer.netty(statelessTransport).serverInfo(new McpSchema.Implementation(properties.getName(), properties.getVersion())).capabilities(this.buildServerCapabilities(properties)).instructions(properties.getInstructions()).requestTimeout(properties.getRequestTimeout()).commandExecutor(this.commandExecutor).objectMapper(properties.getObjectMapper() != null ? properties.getObjectMapper() : JsonParser.getObjectMapper());
            streamableServerNettySpecification.tools(McpToolUtils.toStreamableToolSpecifications(providerToolCallbacks));
            statelessServerNettySpecification.tools(McpToolUtils.toStatelessToolSpecifications(providerToolCallbacks));
            this.streamableServer = streamableServerNettySpecification.build();
            this.statelessServer = statelessServerNettySpecification.build();
            logger.info("Arthas MCP server started successfully");
            logger.info("- MCP Endpoint: {}", (Object)properties.getMcpEndpoint());
            logger.info("- Transport modes: Streamable + Stateless");
            logger.info("- Available tools: {}", (Object)providerToolCallbacks.size());
            logger.info("- Server ready to accept connections");
        }
        catch (Exception e) {
            logger.error("Failed to start Arthas MCP server", e);
            throw new RuntimeException("Failed to start Arthas MCP server", e);
        }
    }

    private NettyStreamableServerTransportProvider createStreamableHttpTransportProvider(McpServerProperties properties) {
        return NettyStreamableServerTransportProvider.builder().mcpEndpoint(properties.getMcpEndpoint()).objectMapper(properties.getObjectMapper() != null ? properties.getObjectMapper() : new ObjectMapper()).build();
    }

    private NettyStatelessServerTransport createStatelessHttpTransport(McpServerProperties properties) {
        return NettyStatelessServerTransport.builder().mcpEndpoint(properties.getMcpEndpoint()).objectMapper(properties.getObjectMapper() != null ? properties.getObjectMapper() : new ObjectMapper()).build();
    }

    private McpSchema.ServerCapabilities buildServerCapabilities(McpServerProperties properties) {
        return McpSchema.ServerCapabilities.builder().prompts(new McpSchema.ServerCapabilities.PromptCapabilities(properties.isPromptChangeNotification())).resources(new McpSchema.ServerCapabilities.ResourceCapabilities(properties.isResourceSubscribe(), properties.isResourceChangeNotification())).tools(new McpSchema.ServerCapabilities.ToolCapabilities(properties.isToolChangeNotification())).build();
    }

    public void stop() {
        logger.info("Stopping Arthas MCP server...");
        try {
            if (this.unifiedMcpHandler != null) {
                logger.debug("Shutting down unified MCP handler");
                this.unifiedMcpHandler.closeGracefully().get();
                logger.info("Unified MCP handler stopped successfully");
            }
            if (this.streamableServer != null) {
                logger.debug("Shutting down streamable server");
                this.streamableServer.closeGracefully().get();
                logger.info("Streamable server stopped successfully");
            }
            if (this.statelessServer != null) {
                logger.debug("Shutting down stateless server");
                this.statelessServer.closeGracefully().get();
                logger.info("Stateless server stopped successfully");
            }
            logger.info("Arthas MCP server stopped completely");
        }
        catch (Exception e) {
            logger.error("Failed to stop Arthas MCP server gracefully", e);
        }
    }
}

