/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server;

import com.taobao.arthas.mcp.server.ArthasMcpServer;
import com.taobao.arthas.mcp.server.CommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArthasMcpBootstrap {
    private static final Logger logger = LoggerFactory.getLogger(ArthasMcpBootstrap.class);
    private ArthasMcpServer mcpServer;
    private final CommandExecutor commandExecutor;
    private final String mcpEndpoint;
    private static ArthasMcpBootstrap instance;

    public ArthasMcpBootstrap(CommandExecutor commandExecutor, String mcpEndpoint) {
        this.commandExecutor = commandExecutor;
        this.mcpEndpoint = mcpEndpoint;
        instance = this;
    }

    public static ArthasMcpBootstrap getInstance() {
        return instance;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public ArthasMcpServer start() {
        logger.info("Initializing Arthas MCP Bootstrap...");
        try {
            logger.debug("Creating MCP server instance with command executor: {}", (Object)this.commandExecutor.getClass().getSimpleName());
            this.mcpServer = new ArthasMcpServer(this.mcpEndpoint, this.commandExecutor);
            logger.debug("MCP server instance created successfully");
            this.mcpServer.start();
            logger.info("Arthas MCP server initialized successfully");
            logger.info("Bootstrap ready - server is operational");
            return this.mcpServer;
        }
        catch (Exception e) {
            logger.error("Failed to initialize Arthas MCP server", e);
            throw new RuntimeException("Failed to initialize Arthas MCP server", e);
        }
    }

    public void shutdown() {
        logger.info("Initiating Arthas MCP Bootstrap shutdown...");
        if (this.mcpServer != null) {
            logger.debug("Stopping MCP server...");
            this.mcpServer.stop();
            logger.info("MCP server stopped");
        } else {
            logger.warn("MCP server was null during shutdown - may not have been properly initialized");
        }
        logger.info("Arthas MCP Bootstrap shutdown completed");
    }
}

