/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.env;

import com.taobao.arthas.core.env.MapPropertySource;
import java.util.Map;

public class SystemEnvironmentPropertySource
extends MapPropertySource {
    public SystemEnvironmentPropertySource(String name, Map<String, Object> source2) {
        super(name, source2);
    }

    @Override
    public boolean containsProperty(String name) {
        return this.getProperty(name) != null;
    }

    @Override
    public Object getProperty(String name) {
        String actualName = this.resolvePropertyName(name);
        return super.getProperty(actualName);
    }

    protected final String resolvePropertyName(String name) {
        String resolvedName = this.checkPropertyName(name);
        if (resolvedName != null) {
            return resolvedName;
        }
        String uppercasedName = name.toUpperCase();
        if (!name.equals(uppercasedName) && (resolvedName = this.checkPropertyName(uppercasedName)) != null) {
            return resolvedName;
        }
        return name;
    }

    private String checkPropertyName(String name) {
        if (this.containsKey(name)) {
            return name;
        }
        String noDotName = name.replace('.', '_');
        if (!name.equals(noDotName) && this.containsKey(noDotName)) {
            return noDotName;
        }
        String noHyphenName = name.replace('-', '_');
        if (!name.equals(noHyphenName) && this.containsKey(noHyphenName)) {
            return noHyphenName;
        }
        String noDotNoHyphenName = noDotName.replace('-', '_');
        if (!noDotName.equals(noDotNoHyphenName) && this.containsKey(noDotNoHyphenName)) {
            return noDotNoHyphenName;
        }
        return null;
    }

    private boolean containsKey(String name) {
        return this.isSecurityManagerPresent() ? ((Map)this.source).keySet().contains(name) : ((Map)this.source).containsKey(name);
    }

    protected boolean isSecurityManagerPresent() {
        return System.getSecurityManager() != null;
    }
}

