/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import arthas.VmTool;
import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.IOUtils;
import com.taobao.arthas.common.VmToolUtils;
import com.taobao.arthas.core.command.express.Express;
import com.taobao.arthas.core.command.express.ExpressException;
import com.taobao.arthas.core.command.express.ExpressFactory;
import com.taobao.arthas.core.command.model.ClassLoaderVO;
import com.taobao.arthas.core.command.model.ObjectVO;
import com.taobao.arthas.core.command.model.VmToolModel;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.cli.OptionCompleteHandler;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ClassLoaderUtils;
import com.taobao.arthas.core.util.ClassUtils;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.middleware.cli.annotations.DefaultValue;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.instrument.Instrumentation;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Name(value="vmtool")
@Summary(value="jvm tool")
@Description(value="\nEXAMPLES:\n  vmtool --action getInstances --className demo.MathGame\n  vmtool --action getInstances --className demo.MathGame --express 'instances.length'\n  vmtool --action getInstances --className demo.MathGame --express 'instances[0]'\n  vmtool --action getInstances --className demo.MathGame -x 2\n  vmtool --action getInstances --className java.lang.String --limit 10\n  vmtool --action getInstances --classLoaderClass org.springframework.boot.loader.LaunchedURLClassLoader --className org.springframework.context.ApplicationContext\n  vmtool --action forceGc\n  vmtool --action interruptThread -t 1\n  vmtool --action mallocTrim\n  vmtool --action mallocStats\n\nWIKI:\n  https://arthas.aliyun.com/doc/vmtool")
public class VmToolCommand
extends AnnotatedCommand {
    private static final Logger logger;
    private VmToolAction action;
    private String className;
    private String express;
    private int threadId;
    private String hashCode = null;
    private String classLoaderClass;
    private int expand;
    private int limit;
    private String libPath;
    private static String defaultLibPath;
    private static VmTool vmTool;

    @Option(shortName="a", longName="action", required=true)
    @Description(value="Action to execute")
    public void setAction(VmToolAction action) {
        this.action = action;
    }

    @Option(longName="className")
    @Description(value="The class name")
    public void setClassName(String className) {
        this.className = className;
    }

    @Option(shortName="x", longName="expand")
    @Description(value="Expand level of object (1 by default)")
    @DefaultValue(value="1")
    public void setExpand(int expand) {
        this.expand = expand;
    }

    @Option(shortName="c", longName="classloader")
    @Description(value="The hash code of the special class's classLoader")
    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    @Option(longName="classLoaderClass")
    @Description(value="The class name of the special class's classLoader.")
    public void setClassLoaderClass(String classLoaderClass) {
        this.classLoaderClass = classLoaderClass;
    }

    @Option(shortName="l", longName="limit")
    @Description(value="Set the limit value of the getInstances action, default value is 10, set to -1 is unlimited")
    @DefaultValue(value="10")
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Option(longName="libPath")
    @Description(value="The specify lib path.")
    public void setLibPath(String path) {
        this.libPath = path;
    }

    @Option(longName="express", required=false)
    @Description(value="The ognl expression, default value is `instances`.")
    public void setExpress(String express) {
        this.express = express;
    }

    @Option(shortName="t", longName="threadId", required=false)
    @Description(value="The id of the thread to be interrupted")
    public void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(CommandProcess process) {
        try {
            Instrumentation inst = process.session().getInstrumentation();
            if (VmToolAction.getInstances.equals((Object)this.action)) {
                void var7_14;
                T[] instances;
                ArrayList matchedClasses;
                int matchedClassSize;
                ClassLoader classLoader;
                block21: {
                    if (this.className == null) {
                        process.end(-1, "The className option cannot be empty!");
                        return;
                    }
                    classLoader = null;
                    if (this.hashCode != null) {
                        classLoader = ClassLoaderUtils.getClassLoader(inst, this.hashCode);
                        if (classLoader == null) {
                            process.end(-1, "Can not find classloader with hashCode: " + this.hashCode + ".");
                            return;
                        }
                    } else {
                        if (this.classLoaderClass != null) {
                            List<ClassLoader> matchedClassLoaders = ClassLoaderUtils.getClassLoaderByClassName(inst, this.classLoaderClass);
                            if (matchedClassLoaders.size() == 1) {
                                classLoader = matchedClassLoaders.get(0);
                                this.hashCode = Integer.toHexString(matchedClassLoaders.get(0).hashCode());
                                break block21;
                            } else {
                                if (matchedClassLoaders.size() > 1) {
                                    List<ClassLoaderVO> classLoaderVOList = ClassUtils.createClassLoaderVOList(matchedClassLoaders);
                                    VmToolModel vmToolModel = new VmToolModel().setClassLoaderClass(this.classLoaderClass).setMatchedClassLoaders(classLoaderVOList);
                                    process.appendResult(vmToolModel);
                                    process.end(-1, "Found more than one classloader by class name, please specify classloader with '-c <classloader hash>'");
                                    return;
                                }
                                process.end(-1, "Can not find classloader by class name: " + this.classLoaderClass + ".");
                                return;
                            }
                        }
                        classLoader = ClassLoader.getSystemClassLoader();
                    }
                }
                if ((matchedClassSize = (matchedClasses = new ArrayList(SearchUtils.searchClassOnly(inst, this.className, false, this.hashCode))).size()) == 0) {
                    process.end(-1, "Can not find class by class name: " + this.className + ".");
                    return;
                }
                if (matchedClassSize > 1) {
                    process.end(-1, "Found more than one class: " + matchedClasses + ", please specify classloader with '-c <classloader hash>'");
                    return;
                }
                T[] TArray = instances = this.vmToolInstance().getInstances((Class)matchedClasses.get(0), this.limit);
                if (this.express != null) {
                    Express unpooledExpress = ExpressFactory.unpooledExpress(classLoader);
                    try {
                        Object object = unpooledExpress.bind(new InstancesWrapper(instances)).get(this.express);
                    }
                    catch (ExpressException e) {
                        logger.warn("ognl: failed execute express: " + this.express, e);
                        process.end(-1, "Failed to execute ognl, exception message: " + e.getMessage() + ", please check $HOME/logs/arthas/arthas.log for more details. ");
                    }
                }
                VmToolModel vmToolModel = new VmToolModel().setValue(new ObjectVO(var7_14, this.expand));
                process.appendResult(vmToolModel);
                process.end();
            } else {
                if (VmToolAction.forceGc.equals((Object)this.action)) {
                    this.vmToolInstance().forceGc();
                    process.write("\n");
                    process.end();
                    return;
                }
                if (VmToolAction.interruptThread.equals((Object)this.action)) {
                    this.vmToolInstance().interruptSpecialThread(this.threadId);
                    process.write("\n");
                    process.end();
                    return;
                }
                if (VmToolAction.mallocTrim.equals((Object)this.action)) {
                    int result = this.vmToolInstance().mallocTrim();
                    process.write("\n");
                    process.end(result == 1 ? 0 : -1, "mallocTrim result: " + (result == 1 ? "true" : (result == 0 ? "false" : "not supported")));
                    return;
                }
                if (VmToolAction.mallocStats.equals((Object)this.action)) {
                    boolean result = this.vmToolInstance().mallocStats();
                    process.write("\n");
                    process.end(result ? 0 : -1, "mallocStats result: " + (result ? "true" : "not supported"));
                    return;
                }
            }
            process.end();
            return;
        }
        catch (Throwable e) {
            logger.error("vmtool error", e);
            process.end(1, "vmtool error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VmTool vmToolInstance() {
        if (vmTool != null) {
            return vmTool;
        }
        if (this.libPath == null) {
            this.libPath = defaultLibPath;
        }
        FileOutputStream tmpLibOutputStream = null;
        FileInputStream libInputStream = null;
        try {
            File tmpLibFile = File.createTempFile("ArthasJniLibrary", null);
            tmpLibOutputStream = new FileOutputStream(tmpLibFile);
            libInputStream = new FileInputStream(this.libPath);
            IOUtils.copy(libInputStream, tmpLibOutputStream);
            this.libPath = tmpLibFile.getAbsolutePath();
            logger.debug("copy {} to {}", (Object)this.libPath, (Object)tmpLibFile);
        }
        catch (Throwable e) {
            try {
                logger.error("try to copy lib error! libPath: {}", (Object)this.libPath, (Object)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(libInputStream);
                IOUtils.close(tmpLibOutputStream);
                throw throwable;
            }
            IOUtils.close(libInputStream);
            IOUtils.close(tmpLibOutputStream);
        }
        IOUtils.close(libInputStream);
        IOUtils.close(tmpLibOutputStream);
        vmTool = VmTool.getInstance(this.libPath);
        return vmTool;
    }

    private Set<String> actions() {
        HashSet<String> values2 = new HashSet<String>();
        for (VmToolAction action : VmToolAction.values()) {
            values2.add(action.toString());
        }
        return values2;
    }

    @Override
    public void complete(Completion completion) {
        ArrayList<OptionCompleteHandler> handlers = new ArrayList<OptionCompleteHandler>();
        handlers.add(new OptionCompleteHandler(){

            @Override
            public boolean matchName(String token) {
                return "-a".equals(token) || "--action".equals(token);
            }

            @Override
            public boolean complete(Completion completion) {
                return CompletionUtils.complete(completion, VmToolCommand.this.actions());
            }
        });
        handlers.add(new OptionCompleteHandler(){

            @Override
            public boolean matchName(String token) {
                return "--className".equals(token);
            }

            @Override
            public boolean complete(Completion completion) {
                return CompletionUtils.completeClassName(completion);
            }
        });
        if (CompletionUtils.completeOptions(completion, handlers)) {
            return;
        }
        super.complete(completion);
    }

    static {
        CodeSource codeSource;
        logger = LoggerFactory.getLogger(VmToolCommand.class);
        vmTool = null;
        String libName = VmToolUtils.detectLibName();
        if (libName != null && (codeSource = VmToolCommand.class.getProtectionDomain().getCodeSource()) != null) {
            try {
                File bootJarPath = new File(codeSource.getLocation().toURI().getSchemeSpecificPart());
                File soFile = new File(bootJarPath.getParentFile(), "lib" + File.separator + libName);
                if (soFile.exists()) {
                    defaultLibPath = soFile.getAbsolutePath();
                }
            }
            catch (Throwable e) {
                logger.error("can not find VmTool so", e);
            }
        }
    }

    static class InstancesWrapper {
        Object instances;

        public InstancesWrapper(Object instances) {
            this.instances = instances;
        }

        public Object getInstances() {
            return this.instances;
        }

        public void setInstances(Object instances) {
            this.instances = instances;
        }
    }

    public static enum VmToolAction {
        getInstances,
        forceGc,
        interruptThread,
        mallocTrim,
        mallocStats;

    }
}

