/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.model;

import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.util.affect.EnhancerAffect;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class EnhancerAffectVO {
    private final long cost;
    private final int methodCount;
    private final int classCount;
    private final long listenerId;
    private Throwable throwable;
    private List<String> classDumpFiles;
    private List<String> methods;
    private String overLimitMsg;

    public EnhancerAffectVO(EnhancerAffect affect) {
        this.cost = affect.cost();
        this.classCount = affect.cCnt();
        this.methodCount = affect.mCnt();
        this.listenerId = affect.getListenerId();
        this.throwable = affect.getThrowable();
        this.overLimitMsg = affect.getOverLimitMsg();
        if (GlobalOptions.isDump) {
            this.classDumpFiles = new ArrayList<String>();
            for (File classDumpFile : affect.getClassDumpFiles()) {
                this.classDumpFiles.add(classDumpFile.getAbsolutePath());
            }
        }
        if (GlobalOptions.verbose) {
            this.methods = new ArrayList<String>();
            this.methods.addAll(affect.getMethods());
        }
    }

    public EnhancerAffectVO(long cost, int methodCount, int classCount, long listenerId) {
        this.cost = cost;
        this.methodCount = methodCount;
        this.classCount = classCount;
        this.listenerId = listenerId;
    }

    public long getCost() {
        return this.cost;
    }

    public int getClassCount() {
        return this.classCount;
    }

    public int getMethodCount() {
        return this.methodCount;
    }

    public long getListenerId() {
        return this.listenerId;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public List<String> getClassDumpFiles() {
        return this.classDumpFiles;
    }

    public void setClassDumpFiles(List<String> classDumpFiles) {
        this.classDumpFiles = classDumpFiles;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public void setMethods(List<String> methods) {
        this.methods = methods;
    }

    public void setOverLimitMsg(String overLimitMsg) {
        this.overLimitMsg = overLimitMsg;
    }

    public String getOverLimitMsg() {
        return this.overLimitMsg;
    }
}

