/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.utils;

public class TypeHelper {
    private static final String[] internalNames = new String[]{"", "void", "byte", "char", "short", "int", "long", "float", "double", "boolean", "Byte", "Character", "Short", "Integer", "Long", "Float", "Double", "String", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.String"};
    private static final String[] externalNames = new String[]{"$", "V", "B", "C", "S", "I", "J", "F", "D", "Z", "Ljava/lang/Byte;", "Ljava/lang/Character;", "Ljava/lang/Short;", "Ljava/lang/Integer;", "Ljava/lang/Long;", "Ljava/lang/Float;", "Ljava/lang/Double;", "Ljava/lang/String;", "Ljava/lang/Byte;", "Ljava/lang/Character;", "Ljava/lang/Short;", "Ljava/lang/Integer;", "Ljava/lang/Long;", "Ljava/lang/Float;", "Ljava/lang/Double;", "Ljava/lang/String;"};

    public static boolean equalDescriptors(String desc1, String desc2) {
        int idx1 = 0;
        int idx2 = 0;
        int len1 = desc1.length();
        int len2 = desc2.length();
        while (idx1 < len1) {
            if (idx2 == len2) {
                return idx1 == len1 - 1 && desc1.charAt(idx1) == '$';
            }
            char char1 = desc1.charAt(idx1);
            char char2 = desc2.charAt(idx2);
            if (char1 == '$' && idx1 == len1 - 1 || char2 == '$' && idx2 == len2 - 1) {
                return true;
            }
            if (char1 != char2) {
                return false;
            }
            if (char1 == 'L') {
                String typeName2;
                int end1;
                int end2 = idx2 + 1;
                for (end1 = idx1 + 1; end1 < len1 && desc1.charAt(end1) != ';'; ++end1) {
                }
                while (end2 < len2 && desc2.charAt(end2) != ';') {
                    ++end2;
                }
                if (end1 == len1 || end2 == len2) {
                    return false;
                }
                String typeName1 = desc1.substring(idx1 + 1, end1);
                if (!typeName1.equals(typeName2 = desc2.substring(idx2 + 1, end2))) {
                    int tailIdx1 = typeName1.lastIndexOf(47);
                    int tailIdx2 = typeName2.lastIndexOf(47);
                    if (tailIdx1 > 0) {
                        if (tailIdx2 > 0) {
                            return false;
                        }
                        if (!typeName2.equals(typeName1.substring(tailIdx1 + 1))) {
                            return false;
                        }
                    } else if (tailIdx2 > 0) {
                        if (!typeName1.equals(typeName2.substring(tailIdx2 + 1))) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                idx1 = end1;
                idx2 = end2;
            }
            ++idx1;
            ++idx2;
        }
        return idx2 == len2;
    }

    public static String externalizeClass(String className) {
        return className.replace('.', '/');
    }

    public static String internalizeClass(String className) {
        String result = className;
        int length = result.length();
        if (result.charAt(length - 1) == ';') {
            result = result.substring(1, length - 2);
        }
        result = result.replace('/', '.');
        return result;
    }

    public static String externalizeType(String typeName) {
        int i;
        String externalName = "";
        String[] typeAndArrayIndices = typeName.split("\\[");
        String baseType = typeAndArrayIndices[0].trim();
        for (i = 1; i < typeAndArrayIndices.length; ++i) {
            String arrayIdx = typeAndArrayIndices[i];
            if (arrayIdx.indexOf("\\]") == 0) continue;
            externalName = externalName + '[';
        }
        for (i = 0; i < internalNames.length; ++i) {
            if (!internalNames[i].equals(baseType)) continue;
            externalName = externalName + externalNames[i];
            return externalName;
        }
        externalName = externalName + "L" + TypeHelper.externalizeClass(baseType) + ";";
        return externalName;
    }

    public static String externalizeDescriptor(String desc) {
        int openIdx = desc.indexOf(40);
        int closeIdx = desc.indexOf(41);
        int length = desc.length();
        if (openIdx != 0) {
            return "";
        }
        if (closeIdx < 0) {
            return "";
        }
        String retType = closeIdx < length ? desc.substring(closeIdx + 1).trim() : "";
        String externalRetType = TypeHelper.externalizeType(retType);
        String argString = desc.substring(1, closeIdx).trim();
        String externalArgs = "";
        if (argString.equals("")) {
            externalArgs = argString;
        } else {
            String[] args2 = desc.substring(1, closeIdx).trim().split(",");
            for (int i = 0; i < args2.length; ++i) {
                externalArgs = externalArgs + TypeHelper.externalizeType(args2[i]);
            }
        }
        return "(" + externalArgs + ")" + externalRetType;
    }

    public static String internalizeDescriptor(String desc) {
        StringBuffer buffer = new StringBuffer();
        String sepr = "";
        int argStart = desc.indexOf(40);
        int argEnd = desc.indexOf(41);
        int max = desc.length();
        if (argStart < 0 || argEnd < 0) {
            return "(...)";
        }
        int arrayCount = 0;
        boolean addSepr = false;
        buffer.append("(");
        int idx = argStart + 1;
        while (idx < max) {
            char next = desc.charAt(idx);
            if (addSepr) {
                while (arrayCount > 0) {
                    buffer.append("[]");
                    --arrayCount;
                }
                buffer.append(sepr);
            }
            addSepr = true;
            switch (next) {
                case 'B': {
                    buffer.append("byte");
                    break;
                }
                case 'C': {
                    buffer.append("char");
                    break;
                }
                case 'S': {
                    buffer.append("short");
                    break;
                }
                case 'I': {
                    buffer.append("int");
                    break;
                }
                case 'J': {
                    buffer.append("long");
                    break;
                }
                case 'Z': {
                    buffer.append("boolean");
                    break;
                }
                case 'F': {
                    buffer.append("float");
                    break;
                }
                case 'D': {
                    buffer.append("double");
                }
                case 'V': {
                    buffer.append("void");
                    break;
                }
                case 'L': {
                    char tailChar;
                    int tailIdx;
                    for (tailIdx = idx + 1; tailIdx < max && (tailChar = desc.charAt(tailIdx)) != ';'; ++tailIdx) {
                        if (tailChar == '/') {
                            tailChar = '.';
                        }
                        buffer.append(tailChar);
                    }
                    idx = tailIdx;
                    break;
                }
                case '[': {
                    ++arrayCount;
                    addSepr = false;
                    break;
                }
                case ')': {
                    if (idx == argEnd - 1) {
                        buffer.append(")");
                    } else {
                        buffer.append(") ");
                    }
                    addSepr = false;
                    break;
                }
                default: {
                    addSepr = false;
                }
            }
            if (++idx < argEnd) {
                sepr = ",";
                continue;
            }
            sepr = "";
        }
        return buffer.toString();
    }

    public static String parseMethodName(String targetMethod) {
        int sigIdx = targetMethod.indexOf("(");
        if (sigIdx > 0) {
            return targetMethod.substring(0, sigIdx).trim();
        }
        return targetMethod;
    }

    public static String parseMethodDescriptor(String targetMethod) {
        int descIdx = targetMethod.indexOf("(");
        if (descIdx >= 0) {
            String desc = targetMethod.substring(descIdx, targetMethod.length()).trim();
            return TypeHelper.externalizeDescriptor(desc);
        }
        return "";
    }
}

