/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.client;

import com.alibaba.arthas.tunnel.common.SimpleHttpResponse;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyClient {
    private static final Logger logger = LoggerFactory.getLogger(ProxyClient.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleHttpResponse query(String targetUrl) throws InterruptedException {
        SimpleHttpResponse simpleHttpResponse;
        block10: {
            NioEventLoopGroup group;
            block8: {
                final Promise httpResponsePromise = GlobalEventExecutor.INSTANCE.newPromise();
                group = new NioEventLoopGroup(1, new DefaultThreadFactory("arthas-ProxyClient", true));
                ChannelFuture closeFuture = null;
                try {
                    Bootstrap b = new Bootstrap();
                    b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000);
                    ((Bootstrap)((Bootstrap)b.group(group)).channel(LocalChannel.class)).handler(new ChannelInitializer<LocalChannel>(){

                        @Override
                        protected void initChannel(LocalChannel ch) {
                            ChannelPipeline p = ch.pipeline();
                            p.addLast(new HttpClientCodec(), new HttpObjectAggregator(0xA00000), new HttpProxyClientHandler(httpResponsePromise));
                        }
                    });
                    LocalAddress localAddress = new LocalAddress("arthas-netty-LocalAddress");
                    Channel localChannel = b.connect(localAddress).sync().channel();
                    DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, targetUrl, Unpooled.EMPTY_BUFFER);
                    request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                    localChannel.writeAndFlush(request);
                    closeFuture = localChannel.closeFuture();
                    logger.info("proxy client connect to server success, targetUrl: " + targetUrl);
                    simpleHttpResponse = (SimpleHttpResponse)httpResponsePromise.get(5000L, TimeUnit.MILLISECONDS);
                    if (closeFuture == null) break block8;
                    closeFuture.addListener(new ChannelFutureListener(group){
                        final /* synthetic */ EventLoopGroup val$group;
                        {
                            this.val$group = eventLoopGroup;
                        }

                        @Override
                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            this.val$group.shutdownGracefully();
                        }
                    });
                }
                catch (Throwable e) {
                    block9: {
                        try {
                            logger.error("ProxyClient error, targetUrl: {}", (Object)targetUrl, (Object)e);
                            if (closeFuture == null) break block9;
                            closeFuture.addListener(new /* invalid duplicate definition of identical inner class */);
                        }
                        catch (Throwable throwable) {
                            if (closeFuture != null) {
                                closeFuture.addListener(new /* invalid duplicate definition of identical inner class */);
                            } else {
                                group.shutdownGracefully();
                            }
                            throw throwable;
                        }
                    }
                    group.shutdownGracefully();
                }
                break block10;
            }
            group.shutdownGracefully();
        }
        return simpleHttpResponse;
        SimpleHttpResponse httpResponse = new SimpleHttpResponse();
        try {
            httpResponse.setContent("error".getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return httpResponse;
    }

    static class HttpProxyClientHandler
    extends SimpleChannelInboundHandler<HttpObject> {
        private Promise<SimpleHttpResponse> promise;
        private SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse();

        public HttpProxyClientHandler(Promise<SimpleHttpResponse> promise) {
            this.promise = promise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
            if (msg instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)msg;
                this.simpleHttpResponse.setStatus(response.status().code());
                if (!response.headers().isEmpty()) {
                    for (String name : response.headers().names()) {
                        for (String value : response.headers().getAll(name)) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("header: {}, value: {}", (Object)name, (Object)value);
                            }
                            this.simpleHttpResponse.addHeader(name, value);
                        }
                    }
                }
            }
            if (msg instanceof HttpContent) {
                HttpContent content = (HttpContent)msg;
                ByteBuf byteBuf = null;
                try {
                    byteBuf = content.content();
                    byte[] bytes = new byte[byteBuf.readableBytes()];
                    byteBuf.readBytes(bytes);
                    this.simpleHttpResponse.setContent(bytes);
                    this.promise.setSuccess(this.simpleHttpResponse);
                    if (content instanceof LastHttpContent) {
                        ctx.close();
                    }
                }
                finally {
                    if (byteBuf != null) {
                        byteBuf.release();
                    }
                }
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            logger.error("Proxy Client error", cause);
            ctx.close();
        }
    }
}

