/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.attach;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachPermission;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;

public abstract class HotSpotAttachProvider
extends AttachProvider {
    private static final String JVM_VERSION = "java.property.java.vm.version";

    public void checkAttachPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AttachPermission("attachVirtualMachine"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VirtualMachineDescriptor> listVirtualMachines() {
        Set<Integer> vms;
        MonitoredHost host;
        ArrayList<VirtualMachineDescriptor> result = new ArrayList<VirtualMachineDescriptor>();
        try {
            host = MonitoredHost.getMonitoredHost(new HostIdentifier((String)null));
            vms = host.activeVms();
        }
        catch (Throwable t) {
            if (t instanceof ExceptionInInitializerError) {
                t = t.getCause();
            }
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            if (t instanceof SecurityException) {
                return result;
            }
            throw new InternalError(t);
        }
        for (Integer vmid : vms) {
            String pid;
            String name = pid = vmid.toString();
            boolean isAttachable = false;
            MonitoredVm mvm = null;
            try {
                mvm = host.getMonitoredVm(new VmIdentifier(pid));
                try {
                    isAttachable = MonitoredVmUtil.isAttachable(mvm);
                    name = MonitoredVmUtil.commandLine(mvm);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!isAttachable) continue;
                result.add(new HotSpotVirtualMachineDescriptor(this, pid, name));
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
            finally {
                if (mvm == null) continue;
                mvm.detach();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testAttachable(String id) throws AttachNotSupportedException {
        MonitoredVm mvm = null;
        try {
            VmIdentifier vmid = new VmIdentifier(id);
            MonitoredHost host = MonitoredHost.getMonitoredHost(vmid);
            mvm = host.getMonitoredVm(vmid);
            if (MonitoredVmUtil.isAttachable(mvm)) {
                return;
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                ThreadDeath td = (ThreadDeath)t;
                throw td;
            }
            return;
        }
        finally {
            if (mvm != null) {
                mvm.detach();
            }
        }
        throw new AttachNotSupportedException("The VM does not support the attach mechanism");
    }

    static class HotSpotVirtualMachineDescriptor
    extends VirtualMachineDescriptor {
        HotSpotVirtualMachineDescriptor(AttachProvider provider, String id, String displayName) {
            super(provider, id, displayName);
        }

        public boolean isAttachable() {
            return true;
        }
    }
}

