/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.MultiMap;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocketConnectOptionsConverter;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ProxyOptions;
import java.util.ArrayList;
import java.util.List;

@DataObject(generateConverter=true)
public class WebSocketConnectOptions
extends RequestOptions {
    public static final ProxyOptions DEFAULT_PROXY_OPTIONS = null;
    public static final WebsocketVersion DEFAULT_VERSION = WebsocketVersion.V13;
    public static final List<String> DEFAULT_SUB_PROTOCOLS = null;
    public static final boolean DEFAULT_ALLOW_ORIGIN_HEADER = true;
    private ProxyOptions proxyOptions;
    private WebsocketVersion version;
    private List<String> subProtocols;
    private boolean allowOriginHeader;

    public WebSocketConnectOptions() {
        this.proxyOptions = DEFAULT_PROXY_OPTIONS;
        this.version = DEFAULT_VERSION;
        this.subProtocols = DEFAULT_SUB_PROTOCOLS;
        this.allowOriginHeader = true;
    }

    public WebSocketConnectOptions(WebSocketConnectOptions other) {
        super(other);
        this.proxyOptions = other.proxyOptions != null ? new ProxyOptions(other.proxyOptions) : null;
        this.version = other.version;
        this.subProtocols = other.subProtocols;
        this.allowOriginHeader = other.allowOriginHeader;
    }

    public WebSocketConnectOptions(JsonObject json) {
        super(json);
        WebSocketConnectOptionsConverter.fromJson(json, this);
    }

    public WebsocketVersion getVersion() {
        return this.version;
    }

    public WebSocketConnectOptions setVersion(WebsocketVersion version) {
        this.version = version;
        return this;
    }

    public List<String> getSubProtocols() {
        return this.subProtocols;
    }

    public WebSocketConnectOptions setSubProtocols(List<String> subProtocols) {
        this.subProtocols = subProtocols;
        return this;
    }

    public WebSocketConnectOptions addSubProtocol(String subprotocol) {
        if (this.subProtocols == null) {
            this.subProtocols = new ArrayList<String>();
        }
        this.subProtocols.add(subprotocol);
        return this;
    }

    @Override
    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    @Override
    public RequestOptions setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public boolean getAllowOriginHeader() {
        return this.allowOriginHeader;
    }

    public WebSocketConnectOptions setAllowOriginHeader(boolean allowOriginHeader) {
        this.allowOriginHeader = allowOriginHeader;
        return this;
    }

    @Override
    public WebSocketConnectOptions setHost(String host) {
        return (WebSocketConnectOptions)super.setHost(host);
    }

    @Override
    public WebSocketConnectOptions setPort(Integer port) {
        return (WebSocketConnectOptions)super.setPort(port);
    }

    @Override
    public WebSocketConnectOptions setSsl(Boolean ssl) {
        return (WebSocketConnectOptions)super.setSsl(ssl);
    }

    @Override
    public WebSocketConnectOptions setURI(String uri) {
        return (WebSocketConnectOptions)super.setURI(uri);
    }

    @Override
    public WebSocketConnectOptions addHeader(String key, String value) {
        return (WebSocketConnectOptions)super.addHeader(key, value);
    }

    @Override
    public WebSocketConnectOptions addHeader(CharSequence key, CharSequence value) {
        return (WebSocketConnectOptions)super.addHeader(key, value);
    }

    @Override
    public WebSocketConnectOptions addHeader(CharSequence key, Iterable<CharSequence> values2) {
        return (WebSocketConnectOptions)super.addHeader(key, values2);
    }

    @Override
    public WebSocketConnectOptions putHeader(String key, String value) {
        return (WebSocketConnectOptions)super.putHeader(key, value);
    }

    @Override
    public WebSocketConnectOptions putHeader(CharSequence key, CharSequence value) {
        return (WebSocketConnectOptions)super.putHeader(key, value);
    }

    @Override
    public WebSocketConnectOptions putHeader(CharSequence key, Iterable<CharSequence> values2) {
        return (WebSocketConnectOptions)super.putHeader(key, values2);
    }

    @Override
    @GenIgnore
    public WebSocketConnectOptions setHeaders(MultiMap headers) {
        return (WebSocketConnectOptions)super.setHeaders(headers);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        WebSocketConnectOptionsConverter.toJson(this, json);
        return json;
    }
}

