/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.telnet.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.termd.core.function.Consumer;
import io.termd.core.function.Supplier;
import io.termd.core.telnet.TelnetBootstrap;
import io.termd.core.telnet.TelnetHandler;
import io.termd.core.telnet.netty.TelnetChannelHandler;

public class NettyTelnetBootstrap
extends TelnetBootstrap {
    private EventLoopGroup group = new NioEventLoopGroup();
    private ChannelGroup channelGroup = new DefaultChannelGroup(ImmediateEventExecutor.INSTANCE);

    @Override
    public NettyTelnetBootstrap setHost(String host) {
        return (NettyTelnetBootstrap)super.setHost(host);
    }

    @Override
    public NettyTelnetBootstrap setPort(int port) {
        return (NettyTelnetBootstrap)super.setPort(port);
    }

    @Override
    public void start(final Supplier<TelnetHandler> factory2, final Consumer<Throwable> doneHandler) {
        ServerBootstrap boostrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)boostrap.group(this.group).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, 100)).handler(new LoggingHandler(LogLevel.INFO))).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) throws Exception {
                NettyTelnetBootstrap.this.channelGroup.add(ch);
                ChannelPipeline p = ch.pipeline();
                TelnetChannelHandler handler = new TelnetChannelHandler(factory2);
                p.addLast(handler);
            }
        });
        boostrap.bind(this.getHost(), this.getPort()).addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

            @Override
            public void operationComplete(Future<? super Void> future) throws Exception {
                if (future.isSuccess()) {
                    doneHandler.accept(null);
                } else {
                    doneHandler.accept(future.cause());
                }
            }
        });
    }

    @Override
    public void stop(final Consumer<Throwable> doneHandler) {
        GenericFutureListener<Future<Object>> adapter = new GenericFutureListener<Future<Object>>(){

            @Override
            public void operationComplete(Future<Object> future) throws Exception {
                try {
                    doneHandler.accept(future.cause());
                }
                finally {
                    NettyTelnetBootstrap.this.group.shutdownGracefully();
                }
            }
        };
        this.channelGroup.close().addListener((GenericFutureListener<? extends Future<? super Void>>)adapter);
    }
}

