/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.http.netty;

import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.termd.core.function.Consumer;
import io.termd.core.http.netty.HttpRequestHandler;
import io.termd.core.http.netty.TtyWebSocketFrameHandler;
import io.termd.core.tty.TtyConnection;

public class TtyServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final ChannelGroup group;
    private final Consumer<TtyConnection> handler;
    private String httpResourcePath;

    public TtyServerInitializer(ChannelGroup group, Consumer<TtyConnection> handler) {
        this(group, handler, null);
    }

    public TtyServerInitializer(ChannelGroup group, Consumer<TtyConnection> handler, String httpResourcePath) {
        this.group = group;
        this.handler = handler;
        this.httpResourcePath = httpResourcePath;
    }

    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new HttpServerCodec());
        pipeline.addLast(new ChunkedWriteHandler());
        pipeline.addLast(new HttpObjectAggregator(65536));
        HttpRequestHandler httpRequestHandler = null;
        httpRequestHandler = this.httpResourcePath == null ? new HttpRequestHandler("/ws") : new HttpRequestHandler("/ws", this.httpResourcePath);
        pipeline.addLast(httpRequestHandler);
        pipeline.addLast(new WebSocketServerProtocolHandler("/ws"));
        pipeline.addLast(new TtyWebSocketFrameHandler(this.group, this.handler, HttpRequestHandler.class));
    }
}

