/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.resolver;

import com.google.common.base.Strings;
import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.resolver.AbstractNameResolver;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;

public class HttpNameResolver
extends AbstractNameResolver {
    public static final String SCHEME = "http";
    private final URI address;

    public HttpNameResolver(URI targetUri) {
        super(targetUri);
        this.address = targetUri;
    }

    @Override
    protected List<EquivalentAddressGroup> computeAddressGroups() {
        if (this.address == null) {
            throw EtcdExceptionFactory.newEtcdException(ErrorCode.INVALID_ARGUMENT, "Unable to resolve endpoint " + this.getTargetUri());
        }
        return Collections.singletonList(new EquivalentAddressGroup(new InetSocketAddress(this.address.getHost(), this.address.getPort() != -1 ? this.address.getPort() : 2379), Strings.isNullOrEmpty(this.getServiceAuthority()) ? Attributes.newBuilder().set(EquivalentAddressGroup.ATTR_AUTHORITY_OVERRIDE, this.address.toString()).build() : Attributes.EMPTY));
    }
}

