/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.ui;

import com.taobao.text.Color;
import com.taobao.text.LineRenderer;
import com.taobao.text.Style;
import com.taobao.text.ui.BorderStyle;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.Layout;
import com.taobao.text.ui.Overflow;
import com.taobao.text.ui.RowElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.ui.TreeElement;
import com.taobao.text.util.Utils;
import groovy.util.BuilderSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UIBuilder
extends BuilderSupport
implements Iterable<LineRenderer> {
    private final List<Element> elements = new ArrayList<Element>();

    public List<Element> getElements() {
        return this.elements;
    }

    protected Object doInvokeMethod(String methodName, Object name, Object args2) {
        return null;
    }

    protected Object createNode(Object name) {
        return this.createNode(name, (Object)null);
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        Element element;
        if ("node".equals(name)) {
            element = value == null ? new TreeElement() : new TreeElement(new LabelElement(value));
        } else if ("label".equals(name)) {
            element = new LabelElement(value);
        } else if ("table".equals(name)) {
            element = new TableElement();
        } else if ("row".equals(name)) {
            element = new RowElement();
        } else if ("header".equals(name)) {
            element = new RowElement(true);
        } else {
            throw new UnsupportedOperationException("Cannot build object with name " + name + " and value " + value);
        }
        Style.Composite style = element.getStyle();
        if (style == null) {
            style = Style.style();
        }
        style = style.bold((Boolean)attributes.get("bold")).underline((Boolean)attributes.get("underline")).blink((Boolean)attributes.get("blink"));
        if (attributes.containsKey("fg")) {
            style = style.foreground((Color)((Object)attributes.get("fg")));
        }
        if (attributes.containsKey("foreground")) {
            style = style.foreground((Color)((Object)attributes.get("foreground")));
        }
        if (attributes.containsKey("bg")) {
            style = style.background((Color)((Object)attributes.get("bg")));
        }
        if (attributes.containsKey("background")) {
            style = style.background((Color)((Object)attributes.get("background")));
        }
        element.setStyle(style);
        if (element instanceof TableElement) {
            Object borderAttr;
            Object rows;
            TableElement table = (TableElement)element;
            Object columns = attributes.get("columns");
            if (columns instanceof Iterable) {
                List list = Utils.list((Iterable)columns);
                int[] weights = new int[list.size()];
                for (int i = 0; i < weights.length; ++i) {
                    weights[i] = (Integer)list.get(i);
                }
                table.withColumnLayout(Layout.weighted(weights));
            }
            if ((rows = attributes.get("rows")) instanceof Iterable) {
                List list = Utils.list((Iterable)rows);
                int[] weights = new int[list.size()];
                for (int i = 0; i < weights.length; ++i) {
                    weights[i] = (Integer)list.get(i);
                }
                table.withRowLayout(Layout.weighted(weights));
            }
            BorderStyle border = (borderAttr = attributes.get("border")) instanceof Boolean && (Boolean)borderAttr != false ? BorderStyle.DASHED : (borderAttr instanceof BorderStyle ? (BorderStyle)((Object)borderAttr) : null);
            table.border(border);
            Object separatorAttr = attributes.get("separator");
            BorderStyle separator = separatorAttr instanceof Boolean && (Boolean)separatorAttr != false ? BorderStyle.DASHED : (separatorAttr instanceof BorderStyle ? (BorderStyle)((Object)separatorAttr) : null);
            table.separator(separator);
            Object overflowAttr = attributes.get("overflow");
            Overflow overflow = "hidden".equals(overflowAttr) ? Overflow.HIDDEN : ("wrap".equals(overflowAttr) ? Overflow.WRAP : (overflowAttr instanceof Overflow ? (Overflow)((Object)separatorAttr) : Overflow.WRAP));
            table.overflow(overflow);
            Object leftCellPaddingAttr = attributes.get("leftCellPadding");
            int leftCellPadding = 0;
            if (leftCellPaddingAttr instanceof Number) {
                leftCellPadding = ((Number)leftCellPaddingAttr).intValue();
            }
            table.setLeftCellPadding(leftCellPadding);
            Object rightCellPaddingAttr = attributes.get("rightCellPadding");
            int rightCellPadding = 0;
            if (rightCellPaddingAttr instanceof Number) {
                rightCellPadding = ((Number)rightCellPaddingAttr).intValue();
            }
            table.setRightCellPadding(rightCellPadding);
        }
        return element;
    }

    protected Object createNode(Object name, Object value) {
        return this.createNode(name, Collections.emptyMap(), value);
    }

    protected Object createNode(Object name, Map attributes) {
        return this.createNode(name, attributes, null);
    }

    protected void setParent(Object parent, Object child) {
        if (parent instanceof TreeElement) {
            TreeElement parentElement = (TreeElement)parent;
            Element childElement = (Element)child;
            parentElement.addChild(childElement);
        } else if (parent instanceof TableElement) {
            TableElement parentElement = (TableElement)parent;
            RowElement childElement = (RowElement)child;
            parentElement.add(childElement);
        } else if (parent instanceof RowElement) {
            RowElement parentElement = (RowElement)parent;
            Element childElement = (Element)child;
            if (child instanceof TreeElement) {
                throw new IllegalArgumentException("A table cannot contain a tree element");
            }
            parentElement.add(childElement);
        } else {
            throw new UnsupportedOperationException("Unrecognized parent " + parent);
        }
    }

    protected void nodeCompleted(Object parent, Object child) {
        if (parent == null) {
            this.elements.add((Element)child);
        }
        super.nodeCompleted(parent, child);
    }

    @Override
    public Iterator<LineRenderer> iterator() {
        return new Iterator<LineRenderer>(){
            Iterator<Element> i;
            {
                this.i = UIBuilder.this.elements.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public LineRenderer next() {
                return this.i.next().renderer();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

