/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text;

import com.taobao.text.CLS;
import com.taobao.text.Format;
import com.taobao.text.ScreenContext;
import com.taobao.text.Screenable;
import com.taobao.text.Style;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;

public class ScreenBuffer
implements Iterable<Object>,
Serializable,
Screenable {
    private final LinkedList<Object> chunks = new LinkedList();
    private Style current = Style.style();
    private Style next = Style.style();
    private final ScreenContext out;

    public ScreenBuffer() {
        this.out = null;
    }

    public ScreenBuffer(ScreenContext out) {
        this.out = out;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.chunks.iterator();
    }

    public void format(Format format, Appendable appendable) throws IOException {
        format.begin(appendable);
        for (Object chunk : this) {
            if (chunk instanceof Style) {
                format.write((Style)chunk, appendable);
                continue;
            }
            if (chunk instanceof CLS) {
                format.cls(appendable);
                continue;
            }
            if (chunk instanceof Character) {
                format.write(((Character)chunk).charValue(), appendable);
                continue;
            }
            format.write((CharSequence)chunk, appendable);
        }
        if (this.next != null && this.next.equals(Style.reset)) {
            format.write(this.next, appendable);
        }
        format.end(appendable);
    }

    public ScreenBuffer append(Iterable<?> data) throws NullPointerException {
        for (Object o : data) {
            this.append(o);
        }
        return this;
    }

    public ScreenBuffer append(Object ... data) throws NullPointerException {
        for (Object o : data) {
            this.append(o);
        }
        return this;
    }

    @Override
    public ScreenBuffer cls() {
        this.chunks.addLast(CLS.INSTANCE);
        return this;
    }

    @Override
    public ScreenBuffer append(Style style) throws NullPointerException {
        this.next = this.next.merge(style);
        return this;
    }

    @Override
    public ScreenBuffer append(char c) {
        if (!this.next.equals(this.current)) {
            if (!Style.style().equals(this.next)) {
                this.chunks.addLast(this.next);
            }
            this.current = this.next;
            this.next = Style.style();
        }
        this.chunks.addLast(Character.valueOf(c));
        return this;
    }

    @Override
    public ScreenBuffer append(CharSequence s2) {
        if (s2.length() > 0) {
            if (!this.next.equals(this.current)) {
                if (!Style.style().equals(this.next)) {
                    this.chunks.addLast(this.next);
                }
                this.current = this.next;
                this.next = Style.style();
            }
            this.chunks.addLast(s2);
        }
        return this;
    }

    @Override
    public ScreenBuffer append(CharSequence s2, int start, int end) {
        if (end != start) {
            if (start != 0 || end != s2.length()) {
                s2 = s2.subSequence(start, end);
            }
            this.append(s2);
        }
        return this;
    }

    public void flush() throws IOException {
        if (this.out != null) {
            for (Object e : this.chunks) {
                if (e instanceof CLS) {
                    this.out.cls();
                    continue;
                }
                if (e instanceof CharSequence) {
                    this.out.append((CharSequence)e);
                    continue;
                }
                if (e instanceof Character) {
                    this.out.append(((Character)e).charValue());
                    continue;
                }
                this.out.append((Style)e);
            }
        }
        this.chunks.clear();
        if (this.out != null) {
            this.out.flush();
        }
    }

    public ScreenBuffer append(ScreenBuffer s2) throws NullPointerException {
        for (Object e : s2.chunks) {
            this.append(e);
        }
        if (s2.next != null && !s2.next.equals(Style.style())) {
            this.append(s2.next);
        }
        return this;
    }

    public ScreenBuffer append(Object o) throws NullPointerException {
        if (o == null) {
            throw new NullPointerException("No null accepted");
        }
        if (o instanceof ScreenBuffer) {
            this.append((ScreenBuffer)o);
        } else if (o instanceof Style) {
            this.append((Style)o);
        } else if (o instanceof CharSequence) {
            this.append((CharSequence)o);
        } else if (o instanceof Character) {
            this.append(((Character)o).charValue());
        } else if (o instanceof CLS) {
            this.cls();
        } else {
            this.append(o.toString());
        }
        return this;
    }

    public boolean contains(Object o) {
        return this.toString().contains(o.toString());
    }

    public boolean isEmpty() {
        return this.chunks.isEmpty();
    }

    public void clear() {
        this.chunks.clear();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ScreenBuffer) {
            ScreenBuffer that = (ScreenBuffer)obj;
            return this.toString().equals(that.toString());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.format(Format.TEXT, sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }
}

