/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util.matcher;

import com.taobao.arthas.core.util.matcher.Matcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public interface GroupMatcher<T>
extends Matcher<T> {
    public void add(Matcher<T> var1);

    public static class Or<T>
    implements GroupMatcher<T> {
        private final Collection<Matcher<T>> matchers;

        public Or() {
            this.matchers = new ArrayList<Matcher<T>>();
        }

        public Or(Matcher<T> ... matchers) {
            this.matchers = Arrays.asList(matchers);
        }

        public Or(Collection<Matcher<T>> matchers) {
            this.matchers = matchers;
        }

        @Override
        public boolean matching(T target) {
            for (Matcher<T> matcher : this.matchers) {
                if (!matcher.matching(target)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void add(Matcher<T> matcher) {
            this.matchers.add(matcher);
        }
    }

    public static class And<T>
    implements GroupMatcher<T> {
        private final Collection<Matcher<T>> matchers;

        public And(Matcher<T> ... matchers) {
            this.matchers = Arrays.asList(matchers);
        }

        @Override
        public boolean matching(T target) {
            for (Matcher<T> matcher : this.matchers) {
                if (matcher.matching(target)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void add(Matcher<T> matcher) {
            this.matchers.add(matcher);
        }
    }
}

