/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.cli.impl;

import com.taobao.arthas.core.shell.cli.CliToken;
import io.termd.core.readline.LineStatus;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class CliTokenImpl
implements CliToken {
    final boolean text;
    final String raw;
    final String value;

    public CliTokenImpl(boolean text, String value) {
        this(text, value, value);
    }

    public CliTokenImpl(boolean text, String raw, String value) {
        this.text = text;
        this.raw = raw;
        this.value = value;
    }

    @Override
    public boolean isText() {
        return this.text;
    }

    @Override
    public boolean isBlank() {
        return !this.text;
    }

    @Override
    public String raw() {
        return this.raw;
    }

    @Override
    public String value() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CliTokenImpl) {
            CliTokenImpl that = (CliTokenImpl)obj;
            return this.text == that.text && this.value.equals(that.value);
        }
        return false;
    }

    public String toString() {
        return "CliToken[text=" + this.text + ",value=" + this.value + "]";
    }

    public static List<CliToken> tokenize(String s2) {
        List<CliToken> tokens = new LinkedList<CliToken>();
        CliTokenImpl.tokenize(s2, 0, tokens);
        tokens = CliTokenImpl.correctPipeChar(tokens);
        return tokens;
    }

    private static List<CliToken> correctPipeChar(List<CliToken> tokens) {
        ArrayList<CliToken> newTokens = new ArrayList<CliToken>(tokens.size() + 4);
        for (CliToken token : tokens) {
            String rawValue;
            String tokenValue = token.value();
            if (tokenValue.length() > 1 && tokenValue.endsWith("|")) {
                tokenValue = tokenValue.substring(0, tokenValue.length() - 1);
                rawValue = token.raw();
                rawValue = rawValue.substring(0, rawValue.length() - 1);
                newTokens.add(new CliTokenImpl(token.isText(), rawValue, tokenValue));
                newTokens.add(new CliTokenImpl(true, "|", "|"));
                continue;
            }
            if (tokenValue.length() > 1 && tokenValue.startsWith("|")) {
                newTokens.add(new CliTokenImpl(true, "|", "|"));
                tokenValue = tokenValue.substring(1);
                rawValue = token.raw();
                rawValue = rawValue.substring(1);
                newTokens.add(new CliTokenImpl(token.isText(), rawValue, tokenValue));
                continue;
            }
            newTokens.add(token);
        }
        return newTokens;
    }

    private static void tokenize(String s2, int index, List<CliToken> builder) {
        block3: while (index < s2.length()) {
            char c = s2.charAt(index);
            switch (c) {
                case '\t': 
                case ' ': {
                    index = CliTokenImpl.blankToken(s2, index, builder);
                    continue block3;
                }
            }
            index = CliTokenImpl.textToken(s2, index, builder);
        }
    }

    private static int textToken(String s2, int index, List<CliToken> builder) {
        LineStatus quoter = new LineStatus();
        int from = index;
        StringBuilder value = new StringBuilder();
        while (index < s2.length()) {
            char c = s2.charAt(index);
            quoter.accept(c);
            if (!quoter.isQuoted() && !quoter.isEscaped() && CliTokenImpl.isBlank(c)) break;
            if (quoter.isCodePoint()) {
                if (quoter.isEscaped() && quoter.isWeaklyQuoted() && c != '\"') {
                    value.append('\\');
                }
                value.append(c);
            }
            ++index;
        }
        builder.add(new CliTokenImpl(true, s2.substring(from, index), value.toString()));
        return index;
    }

    private static int blankToken(String s2, int index, List<CliToken> builder) {
        int from = index;
        while (index < s2.length() && CliTokenImpl.isBlank(s2.charAt(index))) {
            ++index;
        }
        builder.add(new CliTokenImpl(false, s2.substring(from, index)));
        return index;
    }

    private static boolean isBlank(char c) {
        return c == ' ' || c == '\t';
    }
}

