/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.env.convert;

import com.taobao.arthas.core.env.convert.Converter;
import java.util.HashSet;
import java.util.Set;

final class StringToBooleanConverter
implements Converter<String, Boolean> {
    private static final Set<String> trueValues = new HashSet<String>(4);
    private static final Set<String> falseValues = new HashSet<String>(4);

    StringToBooleanConverter() {
    }

    @Override
    public Boolean convert(String source2, Class<Boolean> targetType) {
        String value = source2.trim();
        if ("".equals(value)) {
            return null;
        }
        if (trueValues.contains(value = value.toLowerCase())) {
            return Boolean.TRUE;
        }
        if (falseValues.contains(value)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid boolean value '" + source2 + "'");
    }

    static {
        trueValues.add("true");
        trueValues.add("on");
        trueValues.add("yes");
        trueValues.add("1");
        falseValues.add("false");
        falseValues.add("off");
        falseValues.add("no");
        falseValues.add("0");
    }
}

