/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.rmi;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.VmIdentifier;
import sun.jvmstat.monitor.event.HostEvent;
import sun.jvmstat.monitor.event.HostListener;
import sun.jvmstat.monitor.event.VmStatusChangeEvent;
import sun.jvmstat.monitor.remote.RemoteHost;
import sun.jvmstat.monitor.remote.RemoteVm;
import sun.jvmstat.perfdata.monitor.CountedTimerTask;
import sun.jvmstat.perfdata.monitor.CountedTimerTaskUtils;
import sun.jvmstat.perfdata.monitor.protocol.rmi.RemoteMonitoredVm;
import sun.jvmstat.perfdata.monitor.protocol.rmi.RemoteVmManager;

public class MonitoredHostProvider
extends MonitoredHost {
    private static final String serverName = "/JStatRemoteHost";
    private static final int DEFAULT_POLLING_INTERVAL = 1000;
    private ArrayList<HostListener> listeners;
    private NotifierTask task;
    private HashSet<Integer> activeVms;
    private RemoteVmManager vmManager;
    private RemoteHost remoteHost;
    private Timer timer;

    public MonitoredHostProvider(HostIdentifier hostId) throws MonitorException {
        this.hostId = hostId;
        this.listeners = new ArrayList();
        this.interval = 1000;
        this.activeVms = new HashSet();
        String sn = serverName;
        String path = hostId.getPath();
        if (path != null && path.length() > 0) {
            sn = path;
        }
        String rmiName = hostId.getPort() != -1 ? "rmi://" + hostId.getHost() + ":" + hostId.getPort() + sn : "rmi://" + hostId.getHost() + sn;
        try {
            this.remoteHost = (RemoteHost)Naming.lookup(rmiName);
        }
        catch (RemoteException e) {
            String message = "RMI Registry not available at " + hostId.getHost();
            message = hostId.getPort() == -1 ? message + ":" + 1099 : message + ":" + hostId.getPort();
            if (e.getMessage() != null) {
                throw new MonitorException(message + "\n" + e.getMessage(), e);
            }
            throw new MonitorException(message, e);
        }
        catch (NotBoundException e) {
            String message = e.getMessage();
            if (message == null) {
                message = rmiName;
            }
            throw new MonitorException("RMI Server " + message + " not available", e);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Malformed URL: " + rmiName);
        }
        this.vmManager = new RemoteVmManager(this.remoteHost);
        this.timer = new Timer(true);
    }

    @Override
    public MonitoredVm getMonitoredVm(VmIdentifier vmid) throws MonitorException {
        return this.getMonitoredVm(vmid, 1000);
    }

    @Override
    public MonitoredVm getMonitoredVm(VmIdentifier vmid, int interval) throws MonitorException {
        VmIdentifier nvmid = null;
        try {
            nvmid = this.hostId.resolve(vmid);
            RemoteVm rvm = this.remoteHost.attachVm(vmid.getLocalVmId(), vmid.getMode());
            RemoteMonitoredVm rmvm = new RemoteMonitoredVm(rvm, nvmid, this.timer, interval);
            rmvm.attach();
            return rmvm;
        }
        catch (RemoteException e) {
            throw new MonitorException("Remote Exception attaching to " + nvmid.toString(), e);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Malformed URI: " + vmid.toString(), e);
        }
    }

    @Override
    public void detach(MonitoredVm vm) throws MonitorException {
        RemoteMonitoredVm rmvm = (RemoteMonitoredVm)vm;
        rmvm.detach();
        try {
            this.remoteHost.detachVm(rmvm.getRemoteVm());
        }
        catch (RemoteException e) {
            throw new MonitorException("Remote Exception detaching from " + vm.getVmIdentifier().toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHostListener(HostListener listener) {
        ArrayList<HostListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
            if (this.task == null) {
                this.task = new NotifierTask();
                this.timer.schedule((TimerTask)this.task, 0L, (long)this.interval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHostListener(HostListener listener) {
        ArrayList<HostListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty() && this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterval(int newInterval) {
        ArrayList<HostListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (newInterval == this.interval) {
                return;
            }
            int oldInterval = this.interval;
            super.setInterval(newInterval);
            if (this.task != null) {
                this.task.cancel();
                NotifierTask oldTask = this.task;
                this.task = new NotifierTask();
                CountedTimerTaskUtils.reschedule(this.timer, oldTask, this.task, oldInterval, newInterval);
            }
        }
    }

    @Override
    public Set<Integer> activeVms() throws MonitorException {
        return this.vmManager.activeVms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVmStatusChangedEvents(Set active, Set started, Set terminated) {
        ArrayList registered = null;
        VmStatusChangeEvent ev = null;
        ArrayList<HostListener> arrayList = this.listeners;
        synchronized (arrayList) {
            registered = (ArrayList)this.listeners.clone();
        }
        for (HostListener l : registered) {
            if (ev == null) {
                ev = new VmStatusChangeEvent(this, active, started, terminated);
            }
            l.vmStatusChanged(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireDisconnectedEvents() {
        ArrayList registered = null;
        HostEvent ev = null;
        ArrayList<HostListener> arrayList = this.listeners;
        synchronized (arrayList) {
            registered = (ArrayList)this.listeners.clone();
        }
        for (HostListener l : registered) {
            if (ev == null) {
                ev = new HostEvent(this);
            }
            l.disconnected(ev);
        }
    }

    private class NotifierTask
    extends CountedTimerTask {
        private NotifierTask() {
        }

        @Override
        public void run() {
            super.run();
            HashSet lastActiveVms = MonitoredHostProvider.this.activeVms;
            try {
                MonitoredHostProvider.this.activeVms = (HashSet)MonitoredHostProvider.this.vmManager.activeVms();
            }
            catch (MonitorException e) {
                System.err.println("MonitoredHostProvider: polling task caught MonitorException:");
                e.printStackTrace();
                MonitoredHostProvider.this.setLastException(e);
                MonitoredHostProvider.this.fireDisconnectedEvents();
            }
            if (MonitoredHostProvider.this.activeVms.isEmpty()) {
                return;
            }
            HashSet<Integer> startedVms = new HashSet<Integer>();
            HashSet terminatedVms = new HashSet();
            for (Integer vmid : MonitoredHostProvider.this.activeVms) {
                if (lastActiveVms.contains(vmid)) continue;
                startedVms.add(vmid);
            }
            for (Object o : lastActiveVms) {
                if (MonitoredHostProvider.this.activeVms.contains(o)) continue;
                terminatedVms.add(o);
            }
            if (!startedVms.isEmpty() || !terminatedVms.isEmpty()) {
                MonitoredHostProvider.this.fireVmStatusChangedEvents(MonitoredHostProvider.this.activeVms, startedVms, terminatedVms);
            }
        }
    }
}

