/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.perfdata.monitor.MonitorVersionException;

public abstract class AbstractPerfDataBufferPrologue {
    protected ByteBuffer byteBuffer;
    static final int PERFDATA_PROLOG_OFFSET = 0;
    static final int PERFDATA_PROLOG_MAGIC_OFFSET = 0;
    static final int PERFDATA_PROLOG_BYTEORDER_OFFSET = 4;
    static final int PERFDATA_PROLOG_BYTEORDER_SIZE = 1;
    static final int PERFDATA_PROLOG_MAJOR_OFFSET = 5;
    static final int PERFDATA_PROLOG_MAJOR_SIZE = 1;
    static final int PERFDATA_PROLOG_MINOR_OFFSET = 6;
    static final int PERFDATA_PROLOG_MINOR_SIZE = 1;
    static final int PERFDATA_PROLOG_RESERVEDB1_OFFSET = 7;
    static final int PERFDATA_PROLOG_RESERVEDB1_SIZE = 1;
    static final int PERFDATA_PROLOG_SIZE = 8;
    static final byte PERFDATA_BIG_ENDIAN = 0;
    static final byte PERFDATA_LITTLE_ENDIAN = 1;
    static final int PERFDATA_MAGIC = -889274176;
    public static final String PERFDATA_MAJOR_NAME = "sun.perfdata.majorVersion";
    public static final String PERFDATA_MINOR_NAME = "sun.perfdata.minorVersion";

    public AbstractPerfDataBufferPrologue(ByteBuffer byteBuffer) throws MonitorException {
        this.byteBuffer = byteBuffer.duplicate();
        if (this.getMagic() != -889274176) {
            throw new MonitorVersionException("Bad Magic: " + Integer.toHexString(this.getMagic()));
        }
        this.byteBuffer.order(this.getByteOrder());
    }

    public int getMagic() {
        ByteOrder order = this.byteBuffer.order();
        this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
        this.byteBuffer.position(0);
        int magic = this.byteBuffer.getInt();
        this.byteBuffer.order(order);
        return magic;
    }

    public ByteOrder getByteOrder() {
        this.byteBuffer.position(4);
        byte byte_order = this.byteBuffer.get();
        if (byte_order == 0) {
            return ByteOrder.BIG_ENDIAN;
        }
        return ByteOrder.LITTLE_ENDIAN;
    }

    public int getMajorVersion() {
        this.byteBuffer.position(5);
        return this.byteBuffer.get();
    }

    public int getMinorVersion() {
        this.byteBuffer.position(6);
        return this.byteBuffer.get();
    }

    public abstract boolean isAccessible();

    public abstract boolean supportsAccessible();

    public int getSize() {
        return 8;
    }

    public IntBuffer majorVersionBuffer() {
        int[] holder = new int[]{this.getMajorVersion()};
        IntBuffer ib = IntBuffer.wrap(holder);
        ib.limit(1);
        return ib;
    }

    public IntBuffer minorVersionBuffer() {
        int[] holder = new int[]{this.getMinorVersion()};
        IntBuffer ib = IntBuffer.wrap(holder);
        ib.limit(1);
        return ib;
    }

    public static int getMagic(ByteBuffer bb) {
        int position = bb.position();
        ByteOrder order = bb.order();
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.position(0);
        int magic = bb.getInt();
        bb.order(order);
        bb.position(position);
        return magic;
    }

    public static int getMajorVersion(ByteBuffer bb) {
        int position = bb.position();
        bb.position(5);
        byte major = bb.get();
        bb.position(position);
        return major;
    }

    public static int getMinorVersion(ByteBuffer bb) {
        int position = bb.position();
        bb.position(6);
        byte minor = bb.get();
        bb.position(position);
        return minor;
    }

    public static ByteOrder getByteOrder(ByteBuffer bb) {
        int position = bb.position();
        bb.position(4);
        ByteOrder order = bb.get() == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        bb.position(position);
        return order;
    }
}

