/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CompletableFuture<T> {
    private boolean completed;
    private T value;
    private Throwable ex;

    public synchronized boolean complete(T value) {
        this.completed = true;
        this.value = value;
        this.notifyAll();
        return true;
    }

    public synchronized boolean completeExceptionally(Throwable ex) {
        this.completed = true;
        this.ex = ex;
        this.notifyAll();
        return true;
    }

    public synchronized T get() throws Throwable {
        while (!this.completed) {
            this.wait();
        }
        if (this.ex != null) {
            throw this.ex;
        }
        return this.value;
    }

    public synchronized T get(long timeout2, TimeUnit unit) throws Throwable {
        while (!this.completed) {
            this.wait(unit.toMicros(timeout2));
        }
        if (!this.completed) {
            throw new TimeoutException();
        }
        if (this.ex != null) {
            throw this.ex;
        }
        return this.value;
    }
}

