/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.util;

import com.taobao.text.util.BaseIterator;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;

public class Utils {
    private static final Iterator EMPTY_ITERATOR = Collections.emptyList().iterator();
    private static final Pattern p = Pattern.compile("\\S+");
    private static final Pattern blankPattern = Pattern.compile("^\\s*$");
    private static final Pattern FOO = Pattern.compile("(\\*)|(\\?)|(?:\\[([^)]+)\\])|(\\\\.)");
    private static final int ESCAPE = -1;
    private static final int SCANNING = 0;
    private static final int DOLLAR = 1;
    private static final int EVALUATING = 2;
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public static <E> Iterator<E> iterator() {
        Iterator iterator2 = EMPTY_ITERATOR;
        return iterator2;
    }

    public static <E> Iterator<E> iterator(final E element) {
        return new BaseIterator<E>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public E next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return element;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static <E> E first(Iterable<E> elements) {
        Iterator<E> i = elements.iterator();
        return i.hasNext() ? (E)i.next() : null;
    }

    public static <K, V, M extends Map<K, V>> M map(M map, K key, V value) {
        map.put(key, value);
        return map;
    }

    public static <K, V> HashMap<K, V> map(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <E> HashSet<E> set(E ... elements) {
        HashSet set = new HashSet(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> List<E> list(E ... elements) {
        return Arrays.asList(elements);
    }

    public static <E> List<E> list(Iterable<E> iterable) {
        return Utils.list(iterable.iterator());
    }

    public static <E> List<E> list(Iterator<E> iterator2) {
        ArrayList<E> list = new ArrayList<E>();
        while (iterator2.hasNext()) {
            list.add(iterator2.next());
        }
        return list;
    }

    public static int indexOf(CharSequence s2, int off, char c) {
        int len = s2.length();
        while (off < len) {
            if (s2.charAt(off) == c) {
                return off;
            }
            ++off;
        }
        return -1;
    }

    public static String trimLeft(String s2) {
        int index;
        if (s2 == null) {
            throw new NullPointerException("No null string accepted");
        }
        int len = s2.length();
        for (index = 0; index < len && s2.charAt(index) == ' '; ++index) {
        }
        if (index > 0) {
            return s2.substring(index);
        }
        return s2;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (Utils.hasLength(inString) && Utils.hasLength(oldPattern) && newPattern != null) {
            int pos = 0;
            int index = inString.indexOf(oldPattern);
            if (index < 0) {
                return inString;
            }
            StringBuilder sb = new StringBuilder();
            int patLen = oldPattern.length();
            while (index >= 0) {
                sb.append(inString.substring(pos, index));
                sb.append(newPattern);
                pos = index + patLen;
                index = inString.indexOf(oldPattern, pos);
            }
            sb.append(inString.substring(pos));
            return sb.toString();
        }
        return inString;
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean notBlank(String s2) {
        return !blankPattern.matcher(s2).find();
    }

    public static <E> E notNull(E e1, E e2) {
        if (e1 != null) {
            return e1;
        }
        return e2;
    }

    public static int notNegative(int value) {
        return value >= 0 ? value : 0;
    }

    public static String globexToRegex(String globex) throws NullPointerException {
        if (globex == null) {
            throw new NullPointerException("No null globex accepted");
        }
        StringBuilder regex = new StringBuilder();
        int prev = 0;
        Matcher matcher = FOO.matcher(globex);
        while (matcher.find()) {
            int next = matcher.start();
            if (next > prev) {
                regex.append(Pattern.quote(globex.substring(prev, next)));
            }
            if (matcher.group(1) != null) {
                regex.append(".*");
            } else if (matcher.group(2) != null) {
                regex.append(".");
            } else if (matcher.group(3) != null) {
                regex.append("[");
                regex.append(Pattern.quote(matcher.group(3)));
                regex.append("]");
            } else if (matcher.group(4) != null) {
                regex.append(Pattern.quote(Character.toString(matcher.group(4).charAt(1))));
            } else {
                throw new UnsupportedOperationException("Not handled yet");
            }
            prev = matcher.end();
        }
        if (prev < globex.length()) {
            regex.append(Pattern.quote(globex.substring(prev)));
        }
        return regex.toString();
    }

    public static Exception close(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception e) {
                return e;
            }
        }
        return null;
    }

    public static Exception close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                return e;
            }
        }
        return null;
    }

    public static Exception close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception e) {
                return e;
            }
        }
        return null;
    }

    public static Exception close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception e) {
                return e;
            }
        }
        return null;
    }

    public static Exception close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                return e;
            }
        }
        return null;
    }

    public static Exception close(Context context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (Exception e) {
                return e;
            }
        }
        return null;
    }

    public static <T extends Throwable> void rethrow(Class<T> throwableClass, Throwable cause) throws T {
        Throwable throwable;
        try {
            throwable = (Throwable)throwableClass.newInstance();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        throwable.initCause(cause);
        throw throwable;
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o2 != null && o1.equals(o2);
    }

    public static boolean notEquals(Object o1, Object o2) {
        return !Utils.equals(o1, o2);
    }

    public static Exception flush(Flushable flushable) {
        if (flushable != null) {
            try {
                flushable.flush();
            }
            catch (Exception e) {
                return e;
            }
        }
        return null;
    }

    public static List<String> chunks(CharSequence s2) {
        ArrayList<String> chunks = new ArrayList<String>();
        Matcher m3 = p.matcher(s2);
        while (m3.find()) {
            chunks.add(m3.group());
        }
        return chunks;
    }

    public static String join(Iterable<String> strings, String separator) {
        Iterator<String> i = strings.iterator();
        if (i.hasNext()) {
            String first = i.next();
            if (i.hasNext()) {
                StringBuilder buf = new StringBuilder();
                buf.append(first);
                while (i.hasNext()) {
                    buf.append(separator);
                    buf.append(i.next());
                }
                return buf.toString();
            }
            return first;
        }
        return "";
    }

    public static String[] split(CharSequence s2, char separator) {
        return Utils.foo(s2, separator, 0, 0, 0);
    }

    public static String[] split(CharSequence s2, char separator, int rightPadding) {
        if (rightPadding < 0) {
            throw new IllegalArgumentException("Right padding cannot be negative");
        }
        return Utils.foo(s2, separator, 0, 0, rightPadding);
    }

    private static String[] foo(CharSequence s2, char separator, int count, int from, int rightPadding) {
        int len = s2.length();
        if (from < len) {
            String[] ret;
            int to;
            for (to = from; to < len && s2.charAt(to) != separator; ++to) {
            }
            if (to == len - 1) {
                ret = new String[count + 2 + rightPadding];
                ret[count + 1] = "";
            } else {
                ret = to == len ? new String[count + 1 + rightPadding] : Utils.foo(s2, separator, count + 1, to + 1, rightPadding);
            }
            ret[count] = from == to ? "" : s2.subSequence(from, to).toString();
            return ret;
        }
        if (from == len) {
            return new String[count + rightPadding];
        }
        throw new AssertionError();
    }

    public static String findLongestCommonPrefix(CharSequence ... seqs) {
        return Utils.findLongestCommonPrefix(Arrays.asList(seqs));
    }

    public static String findLongestCommonPrefix(Iterable<? extends CharSequence> seqs) {
        String common = "";
        block0: while (true) {
            String candidate = null;
            for (CharSequence charSequence : seqs) {
                if (common.length() + 1 > charSequence.length()) break block0;
                if (candidate == null) {
                    candidate = charSequence.subSequence(0, common.length() + 1).toString();
                    continue;
                }
                if (!charSequence.subSequence(0, common.length() + 1).toString().equals(candidate)) break block0;
            }
            if (candidate == null) break;
            common = candidate;
        }
        return common;
    }

    public static byte[] readAsBytes(InputStream in) throws IOException {
        return Utils.read(in).toByteArray();
    }

    public static String readAsUTF8(InputStream in) {
        try {
            ByteArrayOutputStream baos = Utils.read(in);
            return baos.toString("UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        try {
            byte[] buffer = new byte[256];
            int l = in.read(buffer);
            while (l != -1) {
                out.write(buffer, 0, l);
                l = in.read(buffer);
            }
        }
        finally {
            Utils.close(in);
        }
    }

    private static ByteArrayOutputStream read(InputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Utils.copy(in, baos);
        return baos;
    }

    public static File toFile(URL url) throws IllegalArgumentException, NullPointerException {
        if (url == null) {
            throw new NullPointerException("No null URL accepted");
        }
        if (!url.getProtocol().equals("file")) {
            throw new IllegalArgumentException("Not file protocol");
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    public static Class<?> resolveToClass(Type implementation, Class<?> type, int parameterIndex) {
        if (implementation == null) {
            throw new NullPointerException("No null type accepted");
        }
        Type resolvedType = Utils.resolve(implementation, type, parameterIndex);
        if (resolvedType != null) {
            return Utils.resolveToClass(resolvedType);
        }
        return null;
    }

    public static Class resolveToClass(Type type) {
        if (type == null) {
            throw new NullPointerException("No null type accepted");
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof TypeVariable) {
            TypeVariable resolvedTypeVariable = (TypeVariable)type;
            return Utils.resolveToClass(resolvedTypeVariable.getBounds()[0]);
        }
        throw new UnsupportedOperationException("Type resolution of " + type + " not yet implemented");
    }

    public static Type resolve(Type implementation, Class<?> type, int parameterIndex) {
        if (implementation == null) {
            throw new NullPointerException();
        }
        if (implementation == type) {
            TypeVariable<Class<?>>[] tp = type.getTypeParameters();
            if (parameterIndex < tp.length) {
                return tp[parameterIndex];
            }
            throw new IllegalArgumentException();
        }
        if (implementation instanceof Class) {
            Class c = (Class)implementation;
            Type gsc = c.getGenericSuperclass();
            Type resolved = null;
            if (gsc == null || (resolved = Utils.resolve(gsc, type, parameterIndex)) == null) {
                // empty if block
            }
            return resolved;
        }
        if (implementation instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)implementation;
            Type[] typeArgs = pt.getActualTypeArguments();
            Type rawType = pt.getRawType();
            if (rawType == type) {
                return typeArgs[parameterIndex];
            }
            if (rawType instanceof Class) {
                Class classRawType = (Class)rawType;
                Type resolved = Utils.resolve(classRawType, type, parameterIndex);
                if (resolved == null) {
                    return null;
                }
                if (resolved instanceof TypeVariable) {
                    TypeVariable resolvedTV = (TypeVariable)resolved;
                    TypeVariable<Class<T>>[] a = classRawType.getTypeParameters();
                    for (int i = 0; i < a.length; ++i) {
                        if (!a[i].equals(resolvedTV)) continue;
                        return Utils.resolve(implementation, classRawType, i);
                    }
                    throw new AssertionError();
                }
                throw new UnsupportedOperationException("Cannot support resolution of " + resolved);
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException("todo " + implementation + " " + implementation.getClass());
    }

    public static boolean instanceOf(Class c, List<String> types) {
        for (String type : types) {
            if (!Utils.instanceOf(c, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean instanceOf(Class c, String type) {
        if (c.getName().equals(type)) {
            return true;
        }
        for (Class<?> i : c.getInterfaces()) {
            if (!Utils.instanceOf(i, type)) continue;
            return true;
        }
        if (c.getSuperclass() != null) {
            return Utils.instanceOf(c.getSuperclass(), type);
        }
        return false;
    }

    public static String interpolate(String interpolated, Map<?, ?> context) throws NullPointerException {
        StringBuilder sb = new StringBuilder();
        int status = 0;
        int prev = 0;
        int length = interpolated.length();
        block10: for (int i = 0; i < length; ++i) {
            char c = interpolated.charAt(i);
            switch (status) {
                case -1: {
                    if (c == '$') {
                        sb.append('$');
                    } else {
                        sb.append('\\').append(c);
                    }
                    status = 0;
                    continue block10;
                }
                case 0: {
                    if (c == '$') {
                        status = 1;
                        continue block10;
                    }
                    if (c == '\\') {
                        status = -1;
                        continue block10;
                    }
                    sb.append(c);
                    continue block10;
                }
                case 1: {
                    if (c == '{') {
                        status = 2;
                        prev = i + 1;
                        continue block10;
                    }
                    sb.append('$').append(c);
                    continue block10;
                }
                case 2: {
                    Object value;
                    String key;
                    int j;
                    if (c != '}') continue block10;
                    for (j = prev + 1; j < i && (j >= length || interpolated.charAt(j - 1) != ':' || interpolated.charAt(j) != '-'); ++j) {
                    }
                    if (j < i) {
                        key = interpolated.substring(prev, j - 1);
                        value = context.get(key);
                        if (value == null) {
                            value = interpolated.substring(j + 1, i);
                        }
                    } else {
                        key = interpolated.substring(prev, i);
                        value = context.get(key);
                    }
                    if (value != null) {
                        sb.append(value);
                    }
                    status = 0;
                }
            }
        }
        switch (status) {
            case 1: {
                sb.append('$');
                break;
            }
            case 2: {
                sb.append("${").append(interpolated, prev, interpolated.length());
            }
        }
        return sb.toString();
    }

    public static File getCurrentDirectory() {
        String userDir = System.getProperty("user.dir");
        return new File(userDir);
    }
}

