/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util.metrics;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class RateCounter {
    private static final int BITS_PER_LONG = 63;
    public static final int DEFAULT_SIZE = 5;
    private final AtomicLong count = new AtomicLong();
    private final AtomicLongArray values;

    public RateCounter() {
        this(5);
    }

    public RateCounter(int size) {
        this.values = new AtomicLongArray(size);
        for (int i = 0; i < this.values.length(); ++i) {
            this.values.set(i, 0L);
        }
        this.count.set(0L);
    }

    public int size() {
        long c = this.count.get();
        if (c > (long)this.values.length()) {
            return this.values.length();
        }
        return (int)c;
    }

    public void update(long value) {
        long c = this.count.incrementAndGet();
        if (c <= (long)this.values.length()) {
            this.values.set((int)c - 1, value);
        } else {
            long r = RateCounter.nextLong(c);
            if (r < (long)this.values.length()) {
                this.values.set((int)r, value);
            }
        }
    }

    public double rate() {
        long c = this.count.get();
        int countLength = 0;
        long sum = 0L;
        countLength = c > (long)this.values.length() ? this.values.length() : (int)c;
        for (int i = 0; i < countLength; ++i) {
            sum += this.values.get(i);
        }
        return (double)sum / (double)countLength;
    }

    private static long nextLong(long n) {
        long val;
        long bits;
        while ((bits = ThreadLocalRandom.current().nextLong() & Long.MAX_VALUE) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }
}

