/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

public class ThreadLocalWatch {
    private final ThreadLocal<LongStack> timestampRef = new ThreadLocal<LongStack>(){

        @Override
        protected LongStack initialValue() {
            return new LongStack(4096);
        }
    };

    public long start() {
        long timestamp = System.nanoTime();
        this.timestampRef.get().push(timestamp);
        return timestamp;
    }

    public long cost() {
        return System.nanoTime() - this.timestampRef.get().pop();
    }

    public double costInMillis() {
        return (double)(System.nanoTime() - this.timestampRef.get().pop()) / 1000000.0;
    }

    static class LongStack {
        private long[] array;
        private int pos = 0;
        private int cap;

        public LongStack(int maxSize) {
            this.array = new long[maxSize];
            this.cap = this.array.length;
        }

        public int size() {
            return this.pos;
        }

        public void push(long value) {
            if (this.pos < this.cap) {
                this.array[this.pos++] = value;
            } else {
                this.pos = 0;
                this.array[this.pos++] = value;
            }
        }

        public long pop() {
            if (this.pos > 0) {
                --this.pos;
                return this.array[this.pos];
            }
            this.pos = this.cap;
            --this.pos;
            return this.array[this.pos];
        }
    }
}

