/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.http;

import com.taobao.arthas.core.shell.term.impl.http.session.HttpSession;
import com.taobao.arthas.core.shell.term.impl.http.session.HttpSessionManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.termd.core.http.HttpTtyConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ExtHttpTtyConnection
extends HttpTtyConnection {
    private ChannelHandlerContext context;

    public ExtHttpTtyConnection(ChannelHandlerContext context) {
        this.context = context;
    }

    @Override
    protected void write(byte[] buffer) {
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeBytes(buffer);
        if (this.context != null) {
            this.context.writeAndFlush(new TextWebSocketFrame(byteBuf));
        }
    }

    @Override
    public void schedule(Runnable task, long delay, TimeUnit unit) {
        if (this.context != null) {
            this.context.executor().schedule(task, delay, unit);
        }
    }

    @Override
    public void execute(Runnable task) {
        if (this.context != null) {
            this.context.executor().execute(task);
        }
    }

    @Override
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    public Map<String, Object> extSessions() {
        Object subject;
        HttpSession httpSession;
        if (this.context != null && (httpSession = HttpSessionManager.getHttpSessionFromContext(this.context)) != null && (subject = httpSession.getAttribute("subject")) != null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("subject", subject);
            return result;
        }
        return Collections.emptyMap();
    }
}

