/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.http;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.security.AuthUtils;
import com.taobao.arthas.core.security.BasicPrincipal;
import com.taobao.arthas.core.security.SecurityAuthenticator;
import com.taobao.arthas.core.server.ArthasBootstrap;
import com.taobao.arthas.core.shell.term.impl.http.session.HttpSession;
import com.taobao.arthas.core.shell.term.impl.http.session.HttpSessionManager;
import com.taobao.arthas.core.util.StringUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.Attribute;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;

public final class BasicHttpAuthenticatorHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(BasicHttpAuthenticatorHandler.class);
    private HttpSessionManager httpSessionManager;
    private SecurityAuthenticator securityAuthenticator = ArthasBootstrap.getInstance().getSecurityAuthenticator();

    public BasicHttpAuthenticatorHandler(HttpSessionManager httpSessionManager) {
        this.httpSessionManager = httpSessionManager;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!this.securityAuthenticator.needLogin()) {
            ctx.fireChannelRead(msg);
            return;
        }
        boolean authed = false;
        if (msg instanceof HttpRequest) {
            Subject subject;
            HttpRequest httpRequest = (HttpRequest)msg;
            HttpSession session = this.httpSessionManager.getOrCreateHttpSession(ctx, httpRequest);
            if (session != null && session.getAttribute("subject") != null) {
                authed = true;
            }
            Principal principal = null;
            if (!authed && (principal = BasicHttpAuthenticatorHandler.extractBasicAuthSubject(httpRequest)) == null) {
                principal = BasicHttpAuthenticatorHandler.extractBasicAuthSubjectFromUrl(httpRequest);
            }
            if (!authed && principal == null) {
                principal = AuthUtils.localPrincipal(ctx);
            }
            if ((subject = this.securityAuthenticator.login(principal)) != null) {
                authed = true;
                if (session != null) {
                    session.setAttribute("subject", subject);
                }
            }
            if (!authed) {
                DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED);
                response.headers().set((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, (Object)"Basic realm=\"arthas webconsole\"");
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
                ctx.writeAndFlush(response);
                ctx.channel().close();
                return;
            }
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            Attribute<HttpSession> attribute = ctx.channel().attr(HttpSessionManager.SESSION_KEY);
            HttpSession session = attribute.get();
            if (session != null) {
                HttpSessionManager.setSessionCookie(response, session);
            }
        }
        super.write(ctx, msg, promise);
    }

    protected static BasicPrincipal extractBasicAuthSubjectFromUrl(HttpRequest request) {
        QueryStringDecoder queryDecoder = new QueryStringDecoder(request.uri());
        Map<String, List<String>> parameters = queryDecoder.parameters();
        List<String> passwords = parameters.get("password");
        if (passwords == null || passwords.size() == 0) {
            return null;
        }
        String password = passwords.get(0);
        String username = "arthas";
        List<String> usernames = parameters.get("username");
        if (usernames != null && !usernames.isEmpty()) {
            username = usernames.get(0);
        }
        BasicPrincipal principal = new BasicPrincipal(username, password);
        logger.debug("Extracted Basic Auth principal from url: {}", (Object)principal);
        return principal;
    }

    protected static BasicPrincipal extractBasicAuthSubject(HttpRequest request) {
        String constraint;
        String auth = request.headers().get(HttpHeaderNames.AUTHORIZATION);
        if (auth != null && (constraint = StringUtils.before(auth, " ")) != null && "Basic".equalsIgnoreCase(constraint.trim())) {
            String decoded = StringUtils.after(auth, " ");
            if (decoded == null) {
                logger.error("Extracted Basic Auth principal failed, bad auth String: {}", (Object)auth);
                return null;
            }
            ByteBuf buf = Unpooled.wrappedBuffer(decoded.getBytes());
            ByteBuf out = Base64.decode(buf);
            String userAndPw = out.toString(Charset.defaultCharset());
            String username = StringUtils.before(userAndPw, ":");
            String password = StringUtils.after(userAndPw, ":");
            BasicPrincipal principal = new BasicPrincipal(username, password);
            logger.debug("Extracted Basic Auth principal from HTTP header: {}", (Object)principal);
            return principal;
        }
        return null;
    }
}

