/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class IOUtils {
    private IOUtils() {
    }

    public static String toString(InputStream inputStream2) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream2.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
    }

    public static byte[] getBytes(InputStream input) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        IOUtils.copy(input, result);
        result.close();
        return result.toByteArray();
    }

    public static IOException close(InputStream input) {
        return IOUtils.close((Closeable)input);
    }

    public static IOException close(OutputStream output) {
        return IOUtils.close((Closeable)output);
    }

    public static IOException close(Reader input) {
        return IOUtils.close((Closeable)input);
    }

    public static IOException close(Writer output) {
        return IOUtils.close((Closeable)output);
    }

    public static IOException close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ioe) {
            return ioe;
        }
        return null;
    }

    public static IOException close(ZipFile zip2) {
        try {
            if (zip2 != null) {
                zip2.close();
            }
        }
        catch (IOException ioe) {
            return ioe;
        }
        return null;
    }

    public static boolean isSubFile(File parent, File child) throws IOException {
        return child.getCanonicalPath().startsWith(parent.getCanonicalPath() + File.separator);
    }

    public static boolean isSubFile(String parent, String child) throws IOException {
        return IOUtils.isSubFile(new File(parent), new File(child));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(String zipFile, String extractFolder) throws IOException {
        File file = new File(zipFile);
        ZipFile zip2 = null;
        try {
            int BUFFER = 8192;
            zip2 = new ZipFile(file);
            File newPath = new File(extractFolder);
            newPath.mkdirs();
            Enumeration<? extends ZipEntry> zipFileEntries = zip2.entries();
            while (zipFileEntries.hasMoreElements()) {
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                File destFile = new File(newPath, currentEntry);
                if (!IOUtils.isSubFile(newPath, destFile)) {
                    throw new IOException("Bad zip entry: " + currentEntry);
                }
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream is = null;
                BufferedOutputStream dest = null;
                try {
                    int currentByte;
                    is = new BufferedInputStream(zip2.getInputStream(entry));
                    byte[] data = new byte[BUFFER];
                    FileOutputStream fos = new FileOutputStream(destFile);
                    dest = new BufferedOutputStream(fos, BUFFER);
                    while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
                        dest.write(data, 0, currentByte);
                    }
                    dest.flush();
                }
                catch (Throwable throwable) {
                    IOUtils.close(dest);
                    IOUtils.close(is);
                    throw throwable;
                }
                IOUtils.close(dest);
                IOUtils.close(is);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(zip2);
            throw throwable;
        }
        IOUtils.close(zip2);
    }
}

