/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.nat.agent.factory;

import com.alibaba.arthas.nat.agent.registry.NativeAgentRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NativeAgentRegistryFactory {
    private static final String FILE_PATH = "META-INF/arthas/com.alibaba.arthas.native.agent.NativeAgentRegistryFactory";
    private static Map<String, NativeAgentRegistry> registrationMap = new ConcurrentHashMap<String, NativeAgentRegistry>();
    private static volatile NativeAgentRegistryFactory nativeAgentRegistryFactory;

    private NativeAgentRegistryFactory() {
        Map<String, String> registrationConfigMap = this.readConfigInfo(FILE_PATH);
        this.loadRegister2Map(registrationConfigMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NativeAgentRegistryFactory getNativeAgentClientRegisterFactory() {
        if (nativeAgentRegistryFactory != null) return nativeAgentRegistryFactory;
        Class<NativeAgentRegistryFactory> clazz = NativeAgentRegistryFactory.class;
        synchronized (NativeAgentRegistryFactory.class) {
            if (nativeAgentRegistryFactory != null) return nativeAgentRegistryFactory;
            nativeAgentRegistryFactory = new NativeAgentRegistryFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return nativeAgentRegistryFactory;
        }
    }

    private void loadRegister2Map(Map<String, String> registrationConfigMap) {
        for (Map.Entry<String, String> entry : registrationConfigMap.entrySet()) {
            String name = entry.getKey();
            String classPath = entry.getValue();
            try {
                Class<?> clazz = Class.forName(classPath);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                NativeAgentRegistry instance = (NativeAgentRegistry)constructor.newInstance(new Object[0]);
                registrationMap.put(name, instance);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Map<String, String> readConfigInfo(String filePath) {
        ConcurrentHashMap<String, String> registrationConfigMap = new ConcurrentHashMap<String, String>();
        ClassLoader classLoader = NativeAgentRegistryFactory.class.getClassLoader();
        try (InputStream inputStream2 = classLoader.getResourceAsStream(filePath);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream2));){
            String line;
            if (inputStream2 == null) {
                throw new IllegalArgumentException("File not found: " + filePath);
            }
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if (line.trim().isEmpty() || !line.contains("=") || (parts = line.split("=", 2)).length != 2) continue;
                registrationConfigMap.put(parts[0].trim(), parts[1].trim());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return registrationConfigMap;
    }

    public NativeAgentRegistry getServiceRegistration(String name) {
        return registrationMap.get(name);
    }
}

