/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.util.Fnv;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;

public final class SymbolTable {
    private final String[] names;
    private final long hashCode64;
    private final short[] mapping;
    private final long[] hashCodes;
    private final long[] hashCodesOrigin;

    public SymbolTable(Class<?> ... input) {
        this(SymbolTable.classNames(input));
    }

    private static String[] classNames(Class ... input) {
        String[] names = new String[input.length];
        for (int i = 0; i < input.length; ++i) {
            names[i] = input[i].getName();
        }
        return names;
    }

    public SymbolTable(String ... input) {
        long hashCode;
        int i;
        TreeSet<String> set = new TreeSet<String>(Arrays.asList(input));
        this.names = new String[set.size()];
        Iterator it = set.iterator();
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            if (!it.hasNext()) continue;
            this.names[i2] = (String)it.next();
        }
        long[] hashCodes = new long[this.names.length];
        for (i = 0; i < this.names.length; ++i) {
            hashCodes[i] = hashCode = Fnv.hashCode64(this.names[i]);
        }
        this.hashCodesOrigin = hashCodes;
        this.hashCodes = Arrays.copyOf(hashCodes, hashCodes.length);
        Arrays.sort(this.hashCodes);
        this.mapping = new short[this.hashCodes.length];
        for (i = 0; i < hashCodes.length; ++i) {
            hashCode = hashCodes[i];
            int index = Arrays.binarySearch(this.hashCodes, hashCode);
            this.mapping[index] = (short)i;
        }
        long hashCode64 = -3750763034362895579L;
        for (long hashCode2 : hashCodes) {
            hashCode64 ^= hashCode2;
            hashCode64 *= 1099511628211L;
        }
        this.hashCode64 = hashCode64;
    }

    public int size() {
        return this.names.length;
    }

    public long hashCode64() {
        return this.hashCode64;
    }

    public String getNameByHashCode(long hashCode) {
        int m3 = Arrays.binarySearch(this.hashCodes, hashCode);
        if (m3 < 0) {
            return null;
        }
        short index = this.mapping[m3];
        return this.names[index];
    }

    public int getOrdinalByHashCode(long hashCode) {
        int m3 = Arrays.binarySearch(this.hashCodes, hashCode);
        if (m3 < 0) {
            return -1;
        }
        return this.mapping[m3] + 1;
    }

    public int getOrdinal(String name) {
        int m3 = Arrays.binarySearch(this.hashCodes, Fnv.hashCode64(name));
        if (m3 < 0) {
            return -1;
        }
        return this.mapping[m3] + 1;
    }

    public String getName(int ordinal) {
        return this.names[ordinal - 1];
    }

    public long getHashCode(int ordinal) {
        return this.hashCodesOrigin[ordinal - 1];
    }
}

