/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.nat.agent.management.web.server.http;

import com.alibaba.arthas.nat.agent.common.handler.HttpOptionRequestHandler;
import com.alibaba.arthas.nat.agent.management.web.server.http.HttpNativeAgentHandler;
import com.alibaba.arthas.nat.agent.management.web.server.http.HttpNativeAgentProxyHandler;
import com.alibaba.arthas.nat.agent.management.web.server.http.HttpResourcesHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestHandler.class);
    private HttpNativeAgentHandler httpNativeAgentHandler = new HttpNativeAgentHandler();
    private HttpNativeAgentProxyHandler httpNativeAgentProxyHandler = new HttpNativeAgentProxyHandler();
    private HttpOptionRequestHandler httpOptionRequestHandler = new HttpOptionRequestHandler();
    private HttpResourcesHandler httpResourcesHandler = new HttpResourcesHandler();

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        String path = new URI(request.uri()).getPath();
        HttpMethod method = request.method();
        FullHttpResponse resp = null;
        if (HttpMethod.GET.equals(method)) {
            if ("/".equals(path)) {
                path = "/index.html";
            }
            resp = this.httpResourcesHandler.handlerResources(request, path);
        }
        if (HttpMethod.OPTIONS.equals(method)) {
            resp = this.httpOptionRequestHandler.handleOptionsRequest(ctx, request);
        }
        if (HttpMethod.POST.equals(method)) {
            if ("/api/native-agent".equals(path)) {
                resp = this.httpNativeAgentHandler.handle(ctx, request);
            }
            if ("/api/native-agent-proxy".equals(path)) {
                resp = this.httpNativeAgentProxyHandler.handle(ctx, request);
            }
        }
        if (resp == null) {
            resp = new DefaultFullHttpResponse(request.getProtocolVersion(), HttpResponseStatus.NOT_FOUND);
            resp.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=utf-8");
        }
        ctx.writeAndFlush(resp).addListener(ChannelFutureListener.CLOSE);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        if (ctx.channel().isActive()) {
            ctx.writeAndFlush(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR));
            ctx.close();
        }
    }
}

