/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.DeliveryContext;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.eventbus.impl.HandlerHolder;
import io.vertx.core.eventbus.impl.MessageImpl;
import io.vertx.core.eventbus.impl.MessageTagExtractor;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import java.util.Iterator;

public abstract class HandlerRegistration<T>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(HandlerRegistration.class);
    public final ContextInternal context;
    public final EventBusImpl bus;
    public final String address;
    public final boolean src;
    private HandlerHolder<T> registered;
    private Object metric;

    HandlerRegistration(ContextInternal context, EventBusImpl bus, String address, boolean src) {
        this.context = context;
        this.bus = bus;
        this.src = src;
        this.address = address;
    }

    void receive(MessageImpl msg) {
        if (this.bus.metrics != null) {
            this.bus.metrics.scheduleMessage(this.metric, msg.isLocal());
        }
        this.context.nettyEventLoop().execute(() -> {
            if (!this.doReceive(msg)) {
                this.discard(msg);
            }
        });
    }

    protected abstract boolean doReceive(Message<T> var1);

    protected abstract void dispatch(Message<T> var1, ContextInternal var2, Handler<Message<T>> var3);

    synchronized void register(String repliedAddress, boolean localOnly, Promise<Void> promise) {
        if (this.registered != null) {
            throw new IllegalStateException();
        }
        this.registered = this.bus.addRegistration(this.address, this, repliedAddress != null, localOnly, promise);
        if (this.bus.metrics != null) {
            this.metric = this.bus.metrics.handlerRegistered(this.address, repliedAddress);
        }
    }

    public synchronized boolean isRegistered() {
        return this.registered != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> unregister() {
        PromiseInternal<Void> promise = this.context.promise();
        HandlerRegistration handlerRegistration = this;
        synchronized (handlerRegistration) {
            if (this.registered != null) {
                this.bus.removeRegistration(this.registered, promise);
                this.registered = null;
                if (this.bus.metrics != null) {
                    this.bus.metrics.handlerUnregistered(this.metric);
                }
            } else {
                promise.complete();
            }
        }
        return promise.future();
    }

    public void unregister(Handler<AsyncResult<Void>> completionHandler) {
        Future<Void> fut = this.unregister();
        if (completionHandler != null) {
            fut.onComplete(completionHandler);
        }
    }

    void dispatch(Handler<Message<T>> theHandler, Message<T> message, ContextInternal context) {
        InboundDeliveryContext deliveryCtx = new InboundDeliveryContext((MessageImpl)message, theHandler, context);
        context.dispatch(deliveryCtx::dispatch);
    }

    void discard(Message<T> msg) {
        String replyAddress;
        if (this.bus.metrics != null) {
            this.bus.metrics.discardMessage(this.metric, ((MessageImpl)msg).isLocal(), msg);
        }
        if ((replyAddress = msg.replyAddress()) != null) {
            msg.reply(new ReplyException(ReplyFailure.TIMEOUT, "Discarded the request. address: " + replyAddress + ", repliedAddress: " + msg.address()));
        }
    }

    @Override
    public void close(Promise<Void> completion) {
        this.unregister(completion);
    }

    private class InboundDeliveryContext
    implements DeliveryContext<T> {
        private final MessageImpl<?, T> message;
        private final Iterator<Handler<DeliveryContext>> iter;
        private final Handler<Message<T>> handler;
        private final ContextInternal context;

        private InboundDeliveryContext(MessageImpl<?, T> message, Handler<Message<T>> handler, ContextInternal context) {
            this.message = message;
            this.handler = handler;
            this.iter = message.bus.receiveInterceptors();
            this.context = context;
        }

        void dispatch() {
            this.next();
        }

        @Override
        public Message<T> message() {
            return this.message;
        }

        @Override
        public void next() {
            block9: {
                if (this.iter.hasNext()) {
                    try {
                        Handler<DeliveryContext> handler = this.iter.next();
                        if (handler != null) {
                            handler.handle(this);
                            break block9;
                        }
                        this.next();
                    }
                    catch (Throwable t) {
                        log.error("Failure in interceptor", t);
                    }
                } else {
                    Object m3 = HandlerRegistration.this.metric;
                    VertxTracer tracer = this.context.tracer();
                    if (HandlerRegistration.this.bus.metrics != null) {
                        HandlerRegistration.this.bus.metrics.messageDelivered(m3, this.message.isLocal());
                    }
                    if (tracer != null && !HandlerRegistration.this.src) {
                        this.message.trace = tracer.receiveRequest(this.context, SpanKind.RPC, TracingPolicy.PROPAGATE, this.message, this.message.isSend() ? "send" : "publish", this.message.headers(), MessageTagExtractor.INSTANCE);
                        HandlerRegistration.this.dispatch(this.message, this.context, this.handler);
                        Object trace = this.message.trace;
                        if (this.message.replyAddress == null && trace != null) {
                            tracer.sendResponse(this.context, null, trace, null, TagExtractor.empty());
                        }
                    } else {
                        HandlerRegistration.this.dispatch(this.message, this.context, this.handler);
                    }
                }
            }
        }

        @Override
        public boolean send() {
            return this.message.isSend();
        }

        @Override
        public Object body() {
            return this.message.receivedBody;
        }
    }
}

